<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class LanguagesSeeder extends Seeder
{
    public function run()
    {
        $now = Carbon::now();

        $languages = [
            [
                'name' => 'Amharic',
                'code' => 'am',
                'native_name' => 'አማርኛ',
                'flag_icon' => 'am.png',
                'is_active' => 1,
                'is_default' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'Oromo',
                'code' => 'om',
                'native_name' => 'Afaan Oromoo',
                'flag_icon' => 'om.png',
                'is_active' => 1,
                'is_default' => 0,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'Tigrinya',
                'code' => 'ti',
                'native_name' => 'ትግርኛ',
                'flag_icon' => 'ti.png',
                'is_active' => 1,
                'is_default' => 0,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'Somali',
                'code' => 'so',
                'native_name' => 'Soomaali',
                'flag_icon' => 'so.png',
                'is_active' => 1,
                'is_default' => 0,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'Afar',
                'code' => 'aa',
                'native_name' => 'Qafaraf',
                'flag_icon' => 'aa.png',
                'is_active' => 1,
                'is_default' => 0,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'English',
                'code' => 'en',
                'native_name' => 'English',
                'flag_icon' => 'en.png',
                'is_active' => 1,
                'is_default' => 0,
                'created_at' => $now,
                'updated_at' => $now
            ]
        ];

        DB::table('languages')->insert($languages);
    }
}