document.addEventListener("DOMContentLoaded", function () {
    var calendarEl = document.getElementById("calendar");

    // Get today's date dynamically
    var today = new Date().toISOString().split("T")[0];

    var calendar = new FullCalendar.Calendar(calendarEl, {

      initialView: "timeGridWeek",
      height: "auto",
      navLinks: true,
      editable: true,
      selectable: true,
      selectMirror: true,
      nowIndicator: true,
        headerToolbar: {
            left: "prev,next today",
            center: "title",
            right: "dayGridMonth,timeGridWeek,timeGridDay,listMonth",
        },

        footerToolbar: {
            left: "prev,next today",
            center: "title",
            right: "dayGridMonth,timeGridWeek,timeGridDay,listMonth",
        },
        initialDate: today,
       

        height: "auto",
        navLinks: true,
        editable: true,
        selectable: true,
        selectMirror: true,
        nowIndicator: true,
        events: [
            {
                id: 1,
                title: "Claim Follow-Up: Policy #45782",
                start: today + "T10:30:00",
                classNames: ["common-style", "bg-light-warning"],
            },
            {
                id: 2,
                title: "Meeting: NIB Bank Client",
                start: today + "T14:00:00",
                classNames: ["common-style", "bg-light-info"],
            },
            {
                id: 3,
                title: "Policy Renewal - Individual",
                start: addDays(today, 1) + "T09:00:00",
                classNames: ["common-style", "bg-light-success"],
            },
            {
                id: 4,
                title: "New Agent Onboarding Session",
                start: addDays(today, 1) + "T14:00:00",
                classNames: ["common-style", "bg-light-primary"],
            },
            {
                id: 5,
                title: "Claims Review Board Meeting",
                start: addDays(today, 2) + "T11:00:00",
                classNames: ["common-style", "bg-light-danger"],
            },
            {
                id: 6,
                title: "Call: New Corporate Lead - EBG Group",
                start: addDays(today, 3) + "T13:30:00",
                classNames: ["common-style", "bg-light-secondary"],
            },
            {
                id: 7,
                title: "Reminder: Unpaid Invoice Follow-up",
                start: addDays(today, 4) + "T16:00:00",
                classNames: ["common-style", "bg-light-warning"],
            },
        ],
    });

    calendar.render();

    // Utility function to add days to today's date
    function addDays(dateString, days) {
        const date = new Date(dateString);
        date.setDate(date.getDate() + days);
        return date.toISOString().split("T")[0];
    }
});
