

function formatTime(seconds) {
    const minutes = Math.floor(seconds / 60);
    const secs = seconds % 60;
    return `${minutes}:${secs < 10 ? '0' : ''}${secs}`;
}

function applyUnhighlightStyles(form) {
	$(form).find(':input').each(function () {
		const $field = $(this);

		// Clear invalid styles
		$field.removeClass('is-invalid').removeAttr('style');

		// Apply valid styles if the field has a value
		if ($field.val() !== '') {
			$field.addClass('is-valid').css({
				"border-color": "var(--bs-form-valid-border-color) !important"
			});

		}
		
	});

	// Reset any styling for icons/buttons
	$(".show-hide").css({
		right: "29px",
		"animation-delay": "-2s"
	});
	$(".deleteEle").css({
		right: "31px",
		"animation-delay": "-2s"
	});
}


let loginInProgress = false;
// jQuery validation rules
$("#loginForm").validate({
	
	validClass: 'success',
	errorElement: 'div',
	errorClass: 'help-block',
	//focusInvalid: false,
	ignore: "",
	//focusCleanup: true,
	rules:
	{
	password: {
	required: true,
	},
	email: {
	required: true,
	email: true // Built-in email validation

	},
	captcha: {
	required: true,
	remote: "captcha/process.php"
	},
	},
	messages:
	{
	password:{
	required: "<i class='icofont icofont-close-circled'></i> Please enter your password"},


	email: {
		required: "<i class='icofont icofont-close-circled'></i> Please enter your email",
		email: "<i class='icofont icofont-close-circled'></i> Please enter a valid email address"
	},
	captcha: "<i class='icofont icofont-close-circled'></i> Incorrect code.",
	},

	highlight: function (e) {

	$( ".help-block" ).hide();
	
	$(e).closest('.form-group').removeClass('is-valid').addClass('is-invalid');							
	

	},

	success: function (e) {

	$(e).closest('.form-group').removeClass('is-invalid');//.addClass('has-info');
	$(e).closest('.form-group').addClass('is-valid');//.addClass('has-info');
	$(e).remove();
	},

	errorElement: 'ul',
	errorPlacement: function (error, element) {
	error.addClass('text-danger');
	element.closest('.form-group').append(error);

	},
	highlight: function (element, errorClass, validClass) {
	$(element).removeClass('is-valid');
	$(element).addClass('is-invalid');							
	$(".show-hide").css('cssText', "right: 29px; animation-delay: -2s;"); 
	$(".deleteEle").css('cssText', "right: 31px; animation-delay: -2s;"); 
	$(".is-invalid").removeAttr("style");
	$('.is-invalid').css('cssText', " border-color: var(--bs-form-invalid-border-color) !important"); 

	},
	unhighlight: function (element, errorClass, validClass) {
	$(element).removeClass('is-invalid');
	$(element).addClass('is-valid');
	$(".show-hide").css('cssText', "right: 29px; animation-delay: -2s;"); 
	$(".deleteEle").css('cssText', "right: 31px; animation-delay: -2s;"); 							
	$(".is-valid").removeAttr("style");
	$('.is-valid').css('cssText', "border-color: var(--bs-form-valid-border-color) !important;"); 
	},

	onkeyup: true,
	submitHandler: function(form) {

		if (loginInProgress) return; // Prevent double click
		loginInProgress = true;

		$.ajax({
			url: window.loginRoute,
			method: 'POST',
			data: $(form).serialize(),
			beforeSend: function() {
				$("#errorMessage, #successMessage").hide();
				$('#errorMessage').stop();
				$("#btn-login").attr("disabled", true).html('&nbsp; Please wait... <i class="left-icon-holder fa fa-spin icofont icofont-spinner-alt-6"></i>');
			},
			success: function(response) {
				applyUnhighlightStyles(form);
				if (response.success) {
					$("#errorMessage").hide();
					$('#successMessage')
					.stop(true, true) // Stop ongoing animations
					.hide() // Hide immediately before injecting new content
					.html(`
						<div class="alert alert-success alert-dismissible fade show animate__animated animate__flipInX" role="alert" >
							<i class="icofont icofont-check-circled"></i>
							<strong>Login Successful!</strong>
							<span>Welcome back! Redirecting to your dashboard...</span>
							<button type="button" class="btn-close" data-bs-dismiss="alert"></button>
						</div>
					`).fadeIn().delay(4000).fadeOut(1000);
	
					setTimeout(() => window.location.href = "/admin/dashboard", 2000);
				}
			},
			error: function(xhr) {

				$("#password").removeClass('is-valid');
				$("#email").removeClass('is-valid');


				applyUnhighlightStyles(form);
				const res = xhr.responseJSON || {};
				let errorMessage = "";

				
	
				if (xhr.status === 429 && res.retry_after) {
				
					let seconds = res.retry_after;
				
					// Disable login button during countdown
					$("#btn-login").attr("disabled", true).html(`Locked <span id="countdown">${formatTime(seconds)}</span>`);
				
					// Show countdown alert immediately
					$('#errorMessage')
						.stop(true, true)
						.hide()
						.html(`
							<div class="alert alert-warning alert-dismissible fade show" role="alert">
								<i class="icofont icofont-warning"></i>
								<strong>Too many attempts!</strong> Try again in <span id="countdown">${formatTime(seconds)}</span>
								<button type="button" class="btn-close" data-bs-dismiss="alert"></button>
							</div>
						`)
						.fadeIn();
				
					// Disable form submission during countdown
					let countdown = setInterval(() => {
						seconds--;
						$('#countdown').text(formatTime(seconds));
						$("#btn-login").html(`Locked <span id="countdown">${formatTime(seconds)}</span>`);
				
						if (seconds <= 0) {
							clearInterval(countdown);
						
							// Replace warning with success alert
							$('#errorMessage').html(`
								<div class="alert alert-success alert-dismissible fade show animate__animated animate__flipInX" role="alert">
									<i class="icofont icofont-check-circled"></i>
									<strong>You can now log in.</strong> Please try again.
									<button type="button" class="btn-close" data-bs-dismiss="alert"></button>
								</div>
							`).fadeIn().delay(10000).slideUp(1000);


							
						
							// Re-enable login
							$("#btn-login").html('Sign in <i class="icofont icofont-sign-in"></i>').attr("disabled", false);
						}
						
					}, 1000);
				
					$("#password").val("");
					return;
				}
				
	
				if (res.errors) {
					for (const key in res.errors) {		
						errorMessage += `<li>${res.errors[key]}</li>`;
					}
				} else if (res.error) {		
					errorMessage = `<li>${res.error}</li>`;
				} else {
					
						errorMessage = `<li>Something went wrong. Please try again.</li>`;
				}
				$('#errorMessage')
				.stop(true, true) // Stop ongoing animations
				.hide() // Hide immediately before injecting new content
				.html(`
					<div class="alert alert-danger alert-dismissible fade show" role="alert">
						<i class="icofont icofont-exclamation-circle"></i>
						<strong>Login Failed!</strong>
						<ul>${errorMessage}</ul>
						<button type="button" class="btn-close" data-bs-dismiss="alert"></button>
					</div>
				`)
				.fadeIn() // Show immediately
				.delay(10000) // Wait 10 seconds
				.slideUp(600); // Hide smoothly
				//$("#password").val("");
				//$("#btn-login").html('Sign in <i class="icofont icofont-sign-in"></i>').attr("disabled", false);
				applyUnhighlightStyles(form);
				$("#password").removeClass('is-valid');
				$("#email").removeClass('is-valid');
				$(".show-hide").css('cssText', "right: 20px; animation-delay: -2s;"); 
			},
			complete: function() {

				applyUnhighlightStyles(form);
				loginInProgress = false;

				setTimeout(() => {
					$("#btn-login")
						.html('Sign in <i class="icofont icofont-sign-in"></i>')
						.attr("disabled", false);
				},1000); // match the delay + slideToggle duration
			
				$("#password").val("");
				$("#password").removeClass('is-valid');
				$("#email").removeClass('is-valid');
				$(".show-hide").css('cssText', "right: 20px; animation-delay: -2s;"); 

			}
		});
	}
	
});


