@extends('layouts.master')

@section('title', 'New Claim')

@section('css')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/quill.snow.css') }}">
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@1.6.2/dist/select2-bootstrap4.min.css"
    rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/min/dropzone.min.css" />
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
<style>
/* Custom progress bar colors for each type */
.toast-success .toast-progress {
    background-color: #198754;
}

.toast-error .toast-progress {
    background-color: #dc3545;
}

.toast-info .toast-progress {
    background-color: #0dcaf0;
}

.toast-warning .toast-progress {
    background-color: #ffc107;
}

#mini-map {
    height: 300px;
    border: 1px solid #ccc;
    border-radius: 8px;
    margin-top: 10px;
}
</style>
@endsection

@section('breadcrumb')
<div class="header-logo-wrapper col-auto">
    <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
</div>
<div class="col-4 col-xl-4 page-title">
    <h4 class="f-w-700">Claim</h4>
    <nav>
        <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
            <li class="breadcrumb-item f-w-400">Create</li>
            <li class="breadcrumb-item f-w-400 active">New Claim</li>
        </ol>
    </nav>
</div>
@endsection

@section('main_content')
<!-- Container-fluid starts-->
<div class="col-md-12">
    <div class="card">
        <div class="card-header">
            <h4>Create Insurance Claim</h4>
            <p class="f-m-light mt-1">Fill in the claim information and proceed through each step.</p>
        </div>
        <div class="card-body">
            <form action="" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
                @csrf
                <div class="row shopping-wizard">
                    <div class="col-12">
                        <div class="row shipping-form g-5">
                            <div class="col-xl-12 ">
                                {{-- Step Navigation --}}
                                <div class="nav nav-pills horizontal-options shipping-options mb-4" id="claim-tab"
                                    role="tablist">
                                    <a class="nav-link b-r-0 active" id="step1-tab" data-bs-toggle="pill" href="#step1"
                                        role="tab" aria-selected="true">
                                        <div class="cart-options">
                                            <div class="stroke-icon-wizard"><i class="fa fa-file-text"></i></div>
                                            <div class="cart-options-content">
                                                <h6>Claim Info</h6>
                                            </div>
                                        </div>
                                    </a>
                                    <a class="nav-link b-r-0" id="step2-tab" data-bs-toggle="pill" href="#step2"
                                        role="tab" aria-selected="false">
                                        <div class="cart-options">
                                            <div class="stroke-icon-wizard"><i class="fa fa-exclamation-triangle"></i>
                                            </div>
                                            <div class="cart-options-content">
                                                <h6>Incident</h6>
                                            </div>
                                        </div>
                                    </a>
                                    <a class="nav-link b-r-0" id="step3-tab" data-bs-toggle="pill" href="#step3"
                                        role="tab" aria-selected="false">
                                        <div class="cart-options">
                                            <div class="stroke-icon-wizard"><i class="fa fa-calculator"></i></div>
                                            <div class="cart-options-content">
                                                <h6>Financials</h6>
                                            </div>
                                        </div>
                                    </a>
                                    <a class="nav-link b-r-0" id="step4-tab" data-bs-toggle="pill" href="#step4"
                                        role="tab" aria-selected="false">
                                        <div class="cart-options">
                                            <div class="stroke-icon-wizard"><i class="fa fa-check-square"></i></div>
                                            <div class="cart-options-content">
                                                <h6>Finish</h6>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                {{-- Tab Content --}}
                                <!-- Tab Content -->
                                <div class="tab-content shipping-content" id="claim-tabContent">

                                    {{-- Step 1: Claim Info --}}
                                    <div class="tab-pane fade show active" id="step1" role="tabpanel"
                                        aria-labelledby="step1-tab">
                                        <div class="section-header mb-3">
                                            <h6 class="f-m-light mt-1">Claim Information</h6>
                                            <p class="text-muted small">
                                                Please provide accurate and complete claim details to ensure proper
                                                processing. All required fields must be filled.
                                            </p>
                                            <hr style="border-top: 1px dotted #ccc;">
                                        </div>

                                        <div class="row g-3">
                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label for="customer_id" class="form-label">Customer</label>
                                                    <select class="form-control select2 required" id="customer_id"
                                                        name="customer_id" style="width: 100%;"></select>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label for="policy_id" class="form-label">Policy Number</label>
                                                    <select id="policy_id" name="policy_id"
                                                        class="form-control required" style="width: 100%"
                                                        disabled></select>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label for="claim_number" class="form-label">Claim Number</label>
                                                    <input type="text" id="claim_number" name="claim_number"
                                                        class="form-control" required>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label for="claim_type" class="form-label">Claim Type</label>
                                                    <select id="claim_type" name="claim_type"
                                                        class="form-control select2" required>
                                                        <option value="">Select Type</option>
                                                        <option value="accident">Accident</option>
                                                        <option value="theft">Theft</option>
                                                        <option value="fire">Fire</option>
                                                        <option value="natural_disaster">Natural Disaster</option>
                                                    </select>
                                                </div>
                                            </div>

                                         <div id="policy-details" class="col-xxl-12 col-lg-4 col-md-6" style="display:none;">
    <div class="project-box b-light1-success p-3">
        <!-- Header Title -->
        <div class="section-header mb-2">
            <h5 class="f-w-500 mb-1">Policy Details</h5>
            <hr style="border-top: 1px dotted #ccc;">
        </div>

        <span id="policy-status" class="badge badge-success mb-2"></span>
        <h6 id="policy-name" class="f-w-500 text-primary"></h6>

        <!-- Policy Type and Description -->
        <div class="mb-3">
            <div class="row details">
                <div class="col-6"><span>Policy Type</span></div>
                <div class="col-6 text-success" id="policy-type"></div>

                <div class="col-12 mt-2">
                    <small class="text-muted">Description</small>
                    <div class="text-success" id="policy-description"></div>
                </div>
            </div>
        </div>

        <!-- Existing Policy Details -->
        <div class="row details">
            <div class="col-6"><span>Start Date</span></div>
            <div class="col-6 text-success" id="policy-start-date"></div>

            <div class="col-6"><span>End Date</span></div>
            <div class="col-6 text-success" id="policy-end-date"></div>

            <div class="col-6"><span>Premium Amount</span></div>
            <div class="col-6 text-success" id="policy-premium"></div>
        </div>

        <!-- Policy Progress -->
        <div class="project-status mt-4">
            <div class="d-flex mb-0">
                <p id="policy-progress-percent">0%</p>
                <div class="flex-grow-1 text-end">
                    <span id="policy-progress-status"></span>
                </div>
            </div>
        </div>
    </div>
</div>

                                        </div>

                                        <div id="policy-loading" style="display:none;" class="mt-3">
                                            <div class="spinner-border text-primary" role="status">
                                                <span class="visually-hidden">Loading...</span>
                                            </div>
                                        </div>

                                        <div class="text-end mt-4">
                                            <button class="btn btn-primary" type="button"
                                                onclick="nextStep('step2-tab')">Next <i
                                                    class="fa fa-arrow-right ms-1"></i></button>
                                        </div>
                                    </div>

                                    {{-- Step 2: Incident --}}
                                    <div class="tab-pane fade" id="step2" role="tabpanel" aria-labelledby="step2-tab">


                                       <div class="section-header mb-3">
                                            <h6 class="f-m-light mt-1">Incident Details</h6>
                                            <p class="text-muted small">
                                              Provide detailed and accurate information about the incident related to the claim. This helps ensure a smooth investigation and resolution.
                                            </p>
                                            <hr style="border-top: 1px dotted #ccc;">
                                        </div>
                                        <div class="row g-3">
                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label for="incident_date" class="form-label">Incident Date</label>
                                                    <input type="date" id="incident_date" name="incident_date"
                                                        class="form-control" required>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <div class="form-group mb-3">
                                                    <label for="incident_description"
                                                        class="form-label">Description</label>
                                                    <textarea id="incident_description" name="incident_description"
                                                        class="form-control" rows="4" required></textarea>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label for="incident_location" class="form-label">Location (click on
                                                        map)</label>
                                                    <input type="text" id="incident_location" name="incident_location"
                                                        class="form-control" placeholder="Latitude, Longitude" readonly
                                                        required>
                                                    <!-- Mini Map Container -->
                                                    <div id="mini-map" class="mt-2"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="text-end mt-4">
                                            <button class="btn btn-primary" type="button"
                                                onclick="nextStep('step3-tab')">Next <i
                                                    class="fa fa-arrow-right ms-1"></i></button>
                                        </div>
                                    </div>

                                    {{-- Step 3: Financials --}}
                                    <div class="tab-pane fade" id="step3" role="tabpanel" aria-labelledby="step3-tab">
                                        <div class="section-header mb-3">
    <h6 class="f-m-light mt-1">Financial & Adjuster Info</h6>
    <p class="text-muted small">
        Enter the financial details related to the claim and provide adjuster information if assigned. Accurate data will help streamline the claims process.
    </p>
    <hr style="border-top: 1px dotted #ccc;">
</div>

                                        <div class="row g-3">
                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label for="claim_amount_requested" class="form-label">Amount
                                                        Requested</label>
                                                    <input type="number" step="0.01" id="claim_amount_requested"
                                                        name="claim_amount_requested" class="form-control" required>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label for="claim_amount_approved" class="form-label">Amount
                                                        Approved</label>
                                                    <input type="number" step="0.01" id="claim_amount_approved"
                                                        name="claim_amount_approved" class="form-control">
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label for="deductible" class="form-label">Deductible</label>
                                                    <input type="number" step="0.01" id="deductible" name="deductible"
                                                        class="form-control">
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label for="settlement_amount" class="form-label">Settlement
                                                        Amount</label>
                                                    <input type="number" step="0.01" id="settlement_amount"
                                                        name="settlement_amount" class="form-control">
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label for="claim_status" class="form-label">Status</label>
                                                    <select id="claim_status" name="claim_status"
                                                        class="form-control select2" required>
                                                        <option value="">Select</option>
                                                        <option value="pending">Pending</option>
                                                        <option value="under_review">Under Review</option>
                                                        <option value="approved">Approved</option>
                                                        <option value="rejected">Rejected</option>
                                                        <option value="settled">Settled</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group mb-3">
                                                    <label for="assigned_adjuster" class="form-label">Assigned
                                                        Adjuster</label>
                                                    <input type="text" id="assigned_adjuster" name="assigned_adjuster"
                                                        class="form-control">
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <div class="form-group mb-3">
                                                    <label for="adjuster_notes" class="form-label">Adjuster
                                                        Notes</label>
                                                    <textarea id="adjuster_notes" name="adjuster_notes"
                                                        class="form-control" rows="3"></textarea>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <div class="form-group mb-3">
                                                    <label for="supporting_documents" class="form-label">Upload
                                                        Supporting Documents</label>
                                                    <input type="file" name="supporting_documents[]"
                                                        class="form-control" multiple>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="text-end mt-4">
                                            <button id="step3-summary-btn" class="btn btn-primary" type="button"
                                                onclick="nextStep('step4-tab')">Next <i
                                                    class="fa fa-arrow-right ms-1"></i></button>
                                        </div>
                                    </div>

                                    {{-- Step 4: Finish --}}
                                    <div class="tab-pane fade" id="step4" role="tabpanel" aria-labelledby="step4-tab">
                                        <div class="order-confirm text-center">
                                            <div class="row g-3 mb-4" id="claim-summary-container">
                                                <!-- Summary card will be updated here -->
                                                <div class="col-xxl-12 col-lg-4 col-md-6">
                                                    <div class="project-box b-light1-success p-3">
                                                        <span class="badge badge-success"
                                                            id="summary-claim-status">Ready</span>

                                                        <h5 class="f-w-500" id="summary-claim-number">Claim #: </h5>

                                                        <div class="d-flex mb-2">
                                                            <i class="fa fa-user-circle me-2 mt-1 text-primary"></i>
                                                            <div class="flex-grow-1">
                                                                <p class="mb-0 fw-bold" id="summary-customer-name"></p>
                                                            </div>
                                                        </div>

                                                        <div class="row g-2 mt-2">
                                                            <div class="col-6">
                                                                <span class="text-muted">Claim Type</span>
                                                                <p id="summary-claim-type"
                                                                    class="fw-semibold text-dark"></p>
                                                            </div>
                                                            <div class="col-6">
                                                                <span class="text-muted">Status</span>
                                                                <p id="summary-claim-status-text"
                                                                    class="fw-semibold text-dark"></p>
                                                            </div>
                                                            <div class="col-6">
                                                                <span class="text-muted">Incident Date</span>
                                                                <p id="summary-incident-date"
                                                                    class="fw-semibold text-dark"></p>
                                                            </div>
                                                            <div class="col-6">
                                                                <span class="text-muted">Location</span>
                                                                <p id="summary-incident-location"
                                                                    class="fw-semibold text-dark"></p>
                                                            </div>
                                                            <div class="col-6">
                                                                <span class="text-muted">Amount Requested</span>
                                                                <p id="summary-amount-requested"
                                                                    class="fw-semibold text-dark"></p>
                                                            </div>
                                                            <div class="col-6">
                                                                <span class="text-muted">Adjuster</span>
                                                                <p id="summary-adjuster" class="fw-semibold text-dark">
                                                                </p>
                                                            </div>
                                                        </div>

                                                        <div class="mt-3">
                                                            <i class="fa fa-sticky-note me-2 text-info"></i>
                                                            <span class="text-muted">Incident Summary</span>
                                                            <p id="summary-incident-description" class="mt-1"></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <button type="submit" class="btn btn-success">Submit Claim <i
                                                    class="fa fa-check-circle ms-1"></i></button>
                                        </div>
                                    </div>
                                </div>


                                {{-- End of tab-content --}}
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- Container-fluid Ends-->
@endsection

@section('scripts')
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/min/dropzone.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/min/dropzone.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>

<script>
$(document).ready(function() {
    $('.select2').select2({
        width: '100%',
        placeholder: "Select an option",
        allowClear: true
    });
});
</script>


<script>
$(document).ready(function() {
    toastr.options = {
        "closeButton": true,
        "debug": false,
        "newestOnTop": false,
        "progressBar": true,
        "positionClass": "toast-bottom-right",
        "preventDuplicates": true,
        "onclick": null,
        "showDuration": "300",
        "hideDuration": "1000",
        "timeOut": "5000",
        "extendedTimeOut": "1000",
        "showEasing": "swing",
        "hideEasing": "linear",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
    };

    // Initialize select2
    $('.select2').select2({
        dropdownParent: $('.tab-pane.active')
    });

    // Disable all tabs except the first
    $('.nav-link').not('.active').addClass('disabled').attr('tabindex', '-1').css('pointer-events', 'none');

    // Email validation regex
    function isValidEmail(email) {
        const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return re.test(email);
    }

    // Helper to add error message to element (supports input groups)
    function addError(el, msg) {
        el.addClass('is-invalid').removeClass('is-valid');
        if (el.parent().hasClass('input-group')) {
            // Remove existing feedback after input-group wrapper
            el.parent().next('.invalid-feedback').remove();
            // Insert error after the input-group container with red text
            el.parent().after(`<div class="invalid-feedback text-danger">${msg}</div>`);
        } else {
            // Remove existing feedback immediately after the input
            el.next('.invalid-feedback').remove();
            // Append the error feedback div immediately after the input with red text
            el.after(`<div class="invalid-feedback text-danger">${msg}</div>`);
        }
    }


    // Helper to clear error message
    function clearError(el) {
        el.removeClass('is-invalid').addClass('is-valid');
        if (el.parent().hasClass('input-group')) {
            el.parent().next('.invalid-feedback').remove();
        } else {
            el.next('.invalid-feedback').remove();
        }
    }

    // Validate a single input element, return true if valid, false otherwise
    function validateInput(el) {
        const val = el.val()?.trim();
        const isRequired = el.prop('required');

        // If not required and empty, clear errors and return valid
        if (!isRequired && !val) {
            el.removeClass('is-invalid is-valid');
            if (el.parent().hasClass('input-group')) {
                el.parent().next('.invalid-feedback').remove();
            } else {
                el.next('.invalid-feedback').remove();
            }
            return true;
        }

        if (isRequired && !val) {
            addError(el, 'This field is required.');
            return false;
        }

        // Email validation
        if (el.attr('type') === 'email' && val && !isValidEmail(val)) {
            addError(el, 'Please enter a valid email address.');
            return false;
        }

        // Numeric-only validation via data attribute
        if (el.data('numeric') === true && val && !/^\d+$/.test(val)) {
            addError(el, 'Please enter only numbers.');
            return false;
        }

        // minlength validation
        const minLen = el.attr('minlength');
        if (minLen && val.length < parseInt(minLen)) {
            addError(el, `Please enter at least ${minLen} characters.`);
            return false;
        }

        // maxlength validation
        const maxLen = el.attr('maxlength');
        if (maxLen && val.length > parseInt(maxLen)) {
            addError(el, `Please enter no more than ${maxLen} characters.`);
            return false;
        }

        // Passed all validations
        clearError(el);
        return true;
    }

    // Validate all inputs inside a step, return true if all valid, false if any invalid
   function validateStep(stepId) {
    let isValid = true;

    // Clear all previous validation states on all inputs, selects, textareas inside the step
    $('#' + stepId + ' input, #' + stepId + ' select, #' + stepId + ' textarea').removeClass('is-invalid is-valid');
    $('#' + stepId + ' .invalid-feedback').remove();

    // Required field validation for all inputs/selects/textareas marked required OR with class 'required'
    $('#' + stepId + ' input[required], #' + stepId + ' select[required], #' + stepId + ' textarea[required], #' + stepId + ' .required').each(function() {
        const el = $(this);
        const val = el.val()?.trim();

        if (!val || val === "0") {
            isValid = false;
            const label = el.closest('.form-group').find('label').text().replace('*', '').trim() || 'This field';
            addError(el, `${label} is required.`);
        } else {
            el.removeClass('is-invalid').addClass('is-valid');
        }
    });

    // Check customer_id explicitly
    const customerId = $('#customer_id').val();
    if (!customerId) {
        isValid = false;
        addError($('#customer_id'), 'Customer is required.');
    }

    // Check policy_id explicitly
    const policyId = $('#policy_id').val();
    if (!policyId) {
        isValid = false;
        addError($('#policy_id'), 'Policy Number is required.');
    }

    return isValid;
}



    // Live validation on input/change
    $('input, select, textarea').on('input change', function() {
        validateInput($(this));
    });

    window.nextStep = function(nextTabId) {
        let currentStep = $('.tab-pane.active').attr('id');

        if (validateStep(currentStep)) {
            $('#' + nextTabId).removeClass('disabled').attr('tabindex', '0').css('pointer-events', 'auto');
            const nextTabTrigger = new bootstrap.Tab(document.getElementById(nextTabId));
            nextTabTrigger.show();

            // Re-init select2 for new tab
            $('.tab-pane.active .select2').select2({
                dropdownParent: $('.tab-pane.active')
            });
        } else {
            toastr.error('Please fill in all required fields before proceeding.');
        }
    };


    $('.nav-link.disabled').on('click', function(e) {
        e.preventDefault();
    });

    $('form').on('submit', function(e) {
        e.preventDefault();

        const steps = ['step1', 'step2', 'step3', 'step4'];
        let allValid = true;

        for (let i = 0; i < steps.length; i++) {
            if (!validateStep(steps[i])) {
                allValid = false;
                toastr.warning(`Please complete step ${i + 1} before submitting.`);
                const tabTrigger = new bootstrap.Tab(document.getElementById(steps[i] + '-tab'));
                tabTrigger.show();
                break;
            }
        }

        if (!allValid) return;

        let formData = new FormData(this);
        const route = "{{ route('claims.store') }}";

        $.ajax({
            url: route,
            type: $(this).attr('method') || 'POST',
            data: formData,
            contentType: false,
            processData: false,
            beforeSend: function() {
                toastr.info('Submitting claim, please wait...');
                $('button[type="submit"]').prop('disabled', true).html(
                    '<span class="spinner-border spinner-border-sm"></span> Submitting...'
                );
            },
            complete: function() {
                $('button[type="submit"]').prop('disabled', false).html('Submit Claim');
            },
            success: function(response) {
                toastr.success('Claim submitted successfully!');
                // Optional: reset form or redirect
                // $('form')[0].reset();
                // $('input, select, textarea').removeClass('is-valid is-invalid');
            },
            error: function(xhr) {
                let message = 'An error occurred while submitting the claim.';
                $('.invalid-feedback').remove();
                $('.is-invalid').removeClass('is-invalid');

                if (xhr.status === 422 && xhr.responseJSON.errors) {
                    const errors = xhr.responseJSON.errors;
                    message = 'Please correct the highlighted errors.';

                    for (const field in errors) {
                        const input = $(`[name="${field}"]`);
                        if (input.length) {
                            // Use addError helper to correctly place error
                            addError(input, errors[field][0]);
                        }
                    }

                    const firstError = $('.is-invalid').first();
                    if (firstError.length) {
                        $('html, body').animate({
                            scrollTop: firstError.offset().top - 100
                        }, 500);
                    }
                } else if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                }

                toastr.error(message);
            }
        });
    });
});




$(document).ready(function() {
    // Load customers
    $('#customer_id').select2({
        placeholder: 'Select a customer',
        ajax: {
            url: '{{ route("customers.select2") }}',
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    term: params.term
                };
            },
            processResults: function(data) {
                return {
                    results: data.results
                };
            }
        }
    });

    // Initialize policy select2
    $('#policy_id').select2({
        placeholder: 'Select a policy',
        disabled: true,
        ajax: {
            url: '', // Will be set dynamically
            dataType: 'json',
            delay: 250,
            processResults: function(data) {
                return {
                    results: data.results
                };
            }
        }
    });

    // On customer select -> load policies
    $('#customer_id').on('change', function() {
        let customerId = $(this).val();

        if (customerId) {
            let url = '{{ route("policies.byCustomer", ":id") }}'.replace(':id', customerId);
            $('#policy_id').val(null).trigger('change'); // reset
            $('#policy_id').prop('disabled', false); // enable

            // Re-initialize Select2 with new AJAX URL
            $('#policy_id').select2({
                placeholder: 'Select a policy',
                ajax: {
                    url: url,
                    dataType: 'json',
                    delay: 250,
                    processResults: function(data) {
                        return {
                            results: data.results
                        };
                    }
                }
            });
        } else {
            $('#policy_id').val(null).trigger('change').prop('disabled', true);
        }
    });
});
</script>


<script>
$('#policy_id').on('change', function() {
    const policyId = $(this).val();

    if (policyId) {
        // Show loader (you can customize this with a spinner element)
        let $loader = $(
            '<div id="policy-loader" class="text-center my-3"><div class="spinner-border text-success" role="status"><span class="visually-hidden">Loading...</span></div></div>'
        );
        $('#policy-details').hide().before($loader);

        $.ajax({
            url: '/admin/policies/' + policyId,
            type: 'GET',
            beforeSend: function() {
                // Optionally clear previous data
                $('#policy-details').hide();
            },
            success: function(data) {
                // Remove loader
                $('#policy-loader').remove();

                // Populate policy detail fields
                $('#policy-name').text(data.policy_type + ' - ' + data.policy_number);
                $('#policy-status')
                    .text(data.status)
                    .removeClass()
                    .addClass('badge')
                    .addClass('badge-' + getStatusColor(data.status));
                $('#policy-description').text(data.coverage_type);

                $('#policy-start-date').text(moment(data.start_date).format('YYYY-MM-DD'));
                $('#policy-end-date').text(moment(data.end_date).format('YYYY-MM-DD'));
                $('#policy-premium').text('ETB ' + parseFloat(data.premium_amount).toFixed(2));
                $('#policy-img').attr('src',
                    '/images/policy-icon.png'); // Replace with dynamic if available

                // Calculate progress
                const start = moment(data.start_date);
                const end = moment(data.end_date);
                const now = moment();
                const totalDuration = end.diff(start, 'days');
                const elapsed = now.diff(start, 'days');
                const progressPercent = Math.min(100, Math.max(0, (elapsed / totalDuration) * 100));

                $('#policy-progress-percent').text(Math.round(progressPercent) + '%');
                $('#policy-progress-status').text(progressPercent < 100 ? 'Active' : 'Expired');
                $('#policy-progress-bar')
                    .css('width', progressPercent + '%')
                    .attr('aria-valuenow', progressPercent);

                // Generate a unique claim number and set it
                const randomPart = Math.floor(100000 + Math.random() * 900000);
                const claimNumber = 'CLM-' + data.policy_number + '-' + randomPart;
                $('#claim_number').val(claimNumber);

                // Show the policy details box
                $('#policy-details').slideDown();
            },
            error: function(xhr) {
                $('#policy-loader').remove();
                toastr.error('Failed to load policy details');
                $('#policy-details').slideUp();
            }
        });
    } else {
        $('#policy-details').slideUp();
    }
});

// Helper: Map status to Bootstrap badge classes
function getStatusColor(status) {
    switch (status.toLowerCase()) {
        case 'active':
            return 'success';
        case 'expired':
            return 'danger';
        case 'pending':
            return 'warning';
        default:
            return 'secondary';
    }
}
</script>

<script>
// Initialize the map
const map = L.map('mini-map').setView([9.03, 38.74], 13); // Default to Addis Ababa

// Add OpenStreetMap tiles
L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
    attribution: '© OpenStreetMap contributors',
}).addTo(map);

let marker;

// Handle map clicks
map.on('click', function(e) {
    const lat = e.latlng.lat.toFixed(6);
    const lng = e.latlng.lng.toFixed(6);

    // Place or move marker
    if (marker) {
        marker.setLatLng(e.latlng);
    } else {
        marker = L.marker(e.latlng).addTo(map);
    }

    // Set value in input
    $('#incident_location').val(`${lat}, ${lng}`);
});
</script>

<script>
function populateClaimSummary() {
    // Grab values from form inputs (adjust selectors to match your form)
    const claimNumber = $('#claim_number').val() || 'N/A';
    const customerName = $('#customer_id option:selected').text() || 'N/A';
    const policyName = $('#policy_id option:selected').text() || 'N/A';
    const claimType = $('select[name="claim_type"] option:selected').text() || 'N/A';
    const claimStatus = $('select[name="claim_status"] option:selected').text() || 'Pending';
    const incidentDate = $('input[name="incident_date"]').val() || 'N/A';
    const incidentLocation = $('#incident_location').val() || 'N/A';
    const amountRequestedRaw = $('input[name="claim_amount_requested"]').val() || '0';
    const adjusterName = $('#adjuster_name').val() || 'N/A'; // make sure your adjuster field id matches
    const incidentDescription = $('textarea[name="incident_description"]').val() || 'N/A';

    // Format amount with $ and commas
    const amountRequested = new Intl.NumberFormat('en-US', {
        style: 'currency',
        currency: 'ETB',
    }).format(amountRequestedRaw);

    // Populate the summary fields
    $('#summary-claim-number').text(`Claim #: ${claimNumber}`);
    $('#summary-customer-name').text(customerName);
    $('#summary-policy-name').text(`Policy: ${policyName}`);
    $('#summary-claim-type').text(claimType);
    $('#summary-claim-status-text').text(claimStatus);
    $('#summary-claim-status').text(claimStatus); // badge text
    $('#summary-incident-date').text(incidentDate);
    $('#summary-incident-location').text(incidentLocation);
    $('#summary-amount-requested').text(amountRequested);
    $('#summary-adjuster').text(adjusterName);
    $('#summary-incident-description').text(incidentDescription);
}

function nextStep(tabId) {
    if (tabId === 'step4-tab') {
        populateClaimSummary(); // Create summary card before showing final step
    }

    // Activate next tab
    document.querySelector('.nav-link.active').classList.remove('active');
    document.querySelector(`#${tabId}`).classList.add('active');

    document.querySelector('.tab-pane.active.show').classList.remove('active', 'show');
    document.querySelector(document.querySelector(`#${tabId}`).getAttribute('href')).classList.add('active', 'show');
}

function generateClaimSummary() {
    // Grab form data
    const customer = $('#customer_id option:selected').text();
    const policy = $('#policy_id option:selected').text();
    const claimNumber = $('#claim_number').val();
    const claimType = $('select[name="claim_type"] option:selected').text();
    const incidentDate = $('input[name="incident_date"]').val();
    const incidentDesc = $('textarea[name="incident_description"]').val();
    const location = $('#incident_location').val();
    const amountRequested = $('input[name="claim_amount_requested"]').val();
    const status = $('select[name="claim_status"] option:selected').text();

    // Build summary card HTML
    const summaryHTML = `
    <div class="col-xxl-4 col-lg-4 col-md-6">
        <div class="project-box b-light1-primary">
            <span class="badge badge-primary">${status || 'Pending'}</span>
            <h5 class="f-w-500">Claim #${claimNumber}</h5>
            <div class="d-flex mb-2">
                <i class="fa fa-user me-2 mt-1"></i>
                <div class="flex-grow-1"><p><strong>Customer:</strong> ${customer}</p></div>
            </div>
            <div class="d-flex mb-2">
                <i class="fa fa-shield-alt me-2 mt-1"></i>
                <div class="flex-grow-1"><p><strong>Policy:</strong> ${policy}</p></div>
            </div>
            <div class="d-flex mb-2">
                <i class="fa fa-exclamation-triangle me-2 mt-1"></i>
                <div class="flex-grow-1"><p><strong>Type:</strong> ${claimType}</p></div>
            </div>
            <div class="d-flex mb-2">
                <i class="fa fa-calendar me-2 mt-1"></i>
                <div class="flex-grow-1"><p><strong>Incident:</strong> ${incidentDate}</p></div>
            </div>
            <div class="d-flex mb-2">
                <i class="fa fa-map-marker-alt me-2 mt-1"></i>
                <div class="flex-grow-1"><p><strong>Location:</strong> ${location}</p></div>
            </div>
            <div class="d-flex mb-2">
                <i class="fa fa-dollar-sign me-2 mt-1"></i>
                <div class="flex-grow-1"><p><strong>Requested:</strong> ${amountRequested}</p></div>
            </div>
            <div>
                <p class="small text-muted"><strong>Description:</strong> ${incidentDesc}</p>
            </div>
        </div>
    </div>`;

    $('#claim-summary').html(summaryHTML);
}

function populateSummary() {
    $('#summary-claim-number').text($('#claim_number').val());
    $('#summary-customer-name').text($('#customer_name option:selected').text());
    $('#summary-policy-name').text('Policy: ' + $('#policy_name').val());
    $('#summary-claim-type').text($('#claim_type').val());
    $('#summary-claim-status').text($('#claim_status').val());
    $('#summary-incident-date').text($('#incident_date').val());
    $('#summary-incident-location').text($('#incident_location').val());
    $('#summary-amount-requested').text('$' + $('#claim_amount_requested').val());
    $('#summary-adjuster').text($('#assigned_adjuster').val());
    $('#summary-incident-description').text($('#incident_description').val());
}

$('#step3-summary-btn').on('click', function() {
    populateSummary();

});
</script>


@endsection
