@extends('layouts.master')


@section('title', 'Admin Dashboard')

@section('css')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/datatables.css') }}">
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/date-range-picker/flatpickr.min.css') }}">

<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/date-picker.css') }}">
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/owlcarousel.css') }}">
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/rating.css') }}">
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/vector-map.css') }}">

<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/range-slider.css') }}">
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/fullcalender.css') }}">

<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/chartist.css') }}">
@endsection

@section('breadcrumb')
<div class="header-logo-wrapper col-auto">
    <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
</div>
<div class="col-4 col-xl-4 page-title">
    <h4 class="f-w-700">Admin dashboard</h4>
    <nav>
        <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
            <li class="breadcrumb-item f-w-400">Dashboard</li>
            <li class="breadcrumb-item f-w-400 active">Admin dashboard</li>
        </ol>
    </nav>
</div>
@endsection

@section('main_content')
<!-- Container-fluid starts-->
<div class="container-fluid default-dashboard">
    <div class="row widget-grid">
        <!-- Customer Growth-->
        <div class="col-xl-3 col-md-6 proorder-xl-2 proorder-md-2">
            <div class="card">
                <div class="card-header card-no-border pb-0">
                    <div class="header-top">
                        <h4>Customer Growth</h4>
                        <div class="dropdown icon-dropdown">
                            <button class="btn dropdown-toggle" id="userdropdown17" type="button"
                                data-bs-toggle="dropdown" aria-expanded="false"><i class="icon-more-alt"></i></button>
                            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown17"><a
                                    class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                    href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a></div>
                        </div>
                    </div>
                </div>
                <div class="card-body pb-0 opening-box">
                    <div class="d-flex align-items-center gap-2">
                        <h2><i class="fa fa-users"></i> 12,463</h2>
                        <div class="d-flex">
                            <p class="mb-0 up-arrow"><i class="fa fa-arrow-up"></i></p><span
                                class="f-w-500 font-success">+ 20.08%</span>
                        </div>
                    </div>
                    <div id="growthchart"> </div>
                </div>
            </div>
        </div>

        <!-- Customer Growth End-->

        <!-- Claims-->

        <div class="col-xl-4 col-md-5 proorder-xl-3 proorder-md-3">
            <div class="card shifts-char-box">
                <div class="card-header card-no-border pb-0">
                    <div class="header-top">
                        <h4>Claims by Status </h4>
                        <div class="d-flex align-items-center gap-3">
                            <div class="location-menu dropdown">
                                <button class="btn dropdown-toggle" id="locationdropdown" data-bs-toggle="dropdown"
                                    aria-expanded="false">Location</button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown">
                                    <a class="dropdown-item"
                                        href="#">Date Picker</a>
                                </div>
                            </div>
                            <div class="dropdown icon-dropdown">
                                <button class="btn dropdown-toggle" id="userdropdown16" type="button"
                                    data-bs-toggle="dropdown" aria-expanded="false"><i
                                        class="icon-more-alt"></i></button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown16"><a
                                        class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                        href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-5">
                            <div class="overview" id="shifts-overview"></div>
                        </div>
                        <div class="col-7 shifts-overview">
                            <div class="d-flex gap-2">
                                <div class="flex-shrink-0"><span class="bg-primary"> </span></div>
                                <div class="flex-grow-1">
                                    <h6>Approved</h6>
                                </div><span>86</span>
                            </div>
                            <div class="d-flex gap-2">
                                <div class="flex-shrink-0"><span class="bg-secondary"></span></div>
                                <div class="flex-grow-1">
                                    <h6>Pending</h6>
                                </div><span>210</span>
                            </div>
                            <div class="d-flex gap-2">
                                <div class="flex-shrink-0"><span class="bg-warning"> </span></div>
                                <div class="flex-grow-1">
                                    <h6>Rejected</h6>
                                </div><span>95</span>
                            </div>
                            <div class="d-flex gap-2">
                                <div class="flex-shrink-0"><span class="bg-tertiary"></span></div>
                                <div class="flex-grow-1">
                                    <h6>Under Review</h6>
                                </div><span>37</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Claims End-->


        <div class="col-xl-5 col-md-6 proorder-xl-1 proorder-md-1">
            <div class="card profile-greeting p-0">
                <div class="card-body">
                    <div class="img-overlay">
                        @php
                        use Carbon\Carbon;

                        $hour = Carbon::now()->hour;
                        $greeting = 'Good day';
                        $emoji = '👋';

                        if ($hour >= 5 && $hour < 12) {
                            $greeting='Good morning' ;
                            $emoji='🌞' ;
                            } elseif ($hour>= 12 && $hour < 17) {
                                $greeting='Good afternoon' ;
                                $emoji='☀️' ;
                                } elseif ($hour>= 17 && $hour < 21) {
                                    $greeting='Good evening' ;
                                    $emoji='🌇' ;
                                    } else {
                                    $greeting='Good night' ;
                                    $emoji='🌙' ;
                                    }
                                    @endphp

                                    <h1>{{ $emoji }} {{ $greeting }}, {{ Auth::user()->first_name }} {{ Auth::user()->last_name }}</h1>
                                    <p class="welcome-msg">
                                        Welcome to the Insurance CRM System — your trusted workspace for managing clients, policies, and claims.
                                    </p>


                    </div>
                </div>
            </div>
        </div>


        <div class="row g-3">
            <!-- Total Customers -->
            <div class="col-xl-3 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top daily-revenue-card">
                            <h4>Total Customers</h4>
                        </div>
                    </div>
                    <div class="card-body pb-0 total-sells">
                        <div class="d-flex align-items-center gap-3">
                            <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/icon/customers.png') }}" alt="icon"></div>
                            <div class="flex-grow-1">
                                <h2>12,540</h2>
                                <p class="text-truncate">As of April 2025</p>
                            </div>
                        </div>
                        <div id="total-customers-chart"></div>
                    </div>
                </div>
            </div>

            <!-- Active Policies -->
            <div class="col-xl-3 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top daily-revenue-card">
                            <h4>Active Policies</h4>
                        </div>
                    </div>
                    <div class="card-body pb-0 total-sells-2">
                        <div class="d-flex align-items-center gap-3">
                            <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/icon/policy.png') }}" alt="icon"></div>
                            <div class="flex-grow-1">
                                <h2>7,320</h2>
                                <p class="text-truncate">Current active count</p>
                            </div>
                        </div>
                        <div id="active-policies-chart"></div>
                    </div>
                </div>
            </div>

            <!-- Pending Claims -->
            <div class="col-xl-3 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top daily-revenue-card">
                            <h4>Pending Claims</h4>
                        </div>
                    </div>
                    <div class="card-body pb-0 total-sells-3">
                        <div class="d-flex align-items-center gap-3">
                            <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/icon/clock.png') }}" alt="icon"></div>
                            <div class="flex-grow-1">
                                <h2>153</h2>
                                <p class="text-truncate">Awaiting assessment</p>
                            </div>
                        </div>
                        <div id="pending-claims-chart"></div>
                    </div>
                </div>
            </div>

            <!-- Approved Claims -->
            <div class="col-xl-3 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top daily-revenue-card">
                            <h4>Approved Claims</h4>
                        </div>
                    </div>
                    <div class="card-body pb-0 total-sells-4">
                        <div class="d-flex align-items-center gap-3">
                            <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/icon/check.png') }}" alt="icon"></div>
                            <div class="flex-grow-1">
                                <h2>5,110</h2>
                                <p class="text-truncate">Approved and paid</p>
                            </div>
                        </div>
                        <div id="approved-claims-chart"></div>
                    </div>
                </div>
            </div>

            <!-- Total Premium Collected -->
            <div class="col-xl-3 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top daily-revenue-card">
                            <h4>Premium Collected</h4>
                        </div>
                    </div>
                    <div class="card-body pb-0 pb-0 total-sells-2">
                        <div class="d-flex align-items-center gap-3">
                            <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/icon/revenue.png') }}" alt="icon"></div>
                            <div class="flex-grow-1">
                                <h2>$4,750,000</h2>
                                <p class="text-truncate">Since Jan 2025</p>
                            </div>
                        </div>
                        <div id="premium-chart"></div>
                    </div>
                </div>
            </div>

            <!-- New Leads This Month -->
            <div class="col-xl-3 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top daily-revenue-card">
                            <h4>New Leads</h4>
                        </div>
                    </div>
                    <div class="card-body pb-0 total-sells-4">
                        <div class="d-flex align-items-center gap-3">
                            <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/icon/leads.png') }}" alt="icon"></div>
                            <div class="flex-grow-1">
                                <h2>210</h2>
                                <p class="text-truncate">In April 2025</p>
                            </div>
                        </div>
                        <div id="leads-chart"></div>
                    </div>
                </div>
            </div>

            <!-- Agent Activities -->
            <div class="col-xl-3 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top daily-revenue-card">
                            <h4>Agent Activities</h4>
                        </div>
                    </div>
                    <div class="card-body pb-0 total-sells">
                        <div class="d-flex align-items-center gap-3">
                            <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/icon/agent.png') }}" alt="icon"></div>
                            <div class="flex-grow-1">
                                <h2>95</h2>
                                <p class="text-truncate">Calls made today</p>
                            </div>
                        </div>
                        <div id="agent-activity-chart"></div>
                    </div>
                </div>
            </div>

            <!-- Unpaid Invoices -->
            <div class="col-xl-3 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top daily-revenue-card">
                            <h4>Unpaid Invoices</h4>
                        </div>
                    </div>
                    <div class="card-body pb-0 total-sells-3">
                        <div class="d-flex align-items-center gap-3">
                            <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/icon/invoice.png') }}" alt="icon"></div>
                            <div class="flex-grow-1">
                                <h2>45</h2>
                                <p class="text-truncate">Pending collections</p>
                            </div>
                        </div>
                        <div id="invoice-chart"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xxl-7 col-xl-12 box-col-12 proorder-xl-8 proorder-md-9">
            <div class="card">
                <div class="card-header card-no-border pb-0">
                    <div class="header-top">
                        <h4>Sales Statistic</h4>
                        <div class="dropdown icon-dropdown">
                            <button class="btn dropdown-toggle" id="userdropdown14" type="button"
                                data-bs-toggle="dropdown" aria-expanded="false"><i
                                    class="icon-more-alt"></i></button>
                            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown14"><a
                                    class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                    href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body sale-statistic">
                    <div class="row">
                        <div class="col-3 statistic-icon">
                            <div class="light-card balance-card widget-hover">
                                <div class="icon-box"><img
                                        src="{{ asset('assets/images/dashboard/icon/customers.png') }}"
                                        alt=""></div>
                                <div> <span class="f-w-500 f-light">Total Premium</span>
                                    <h5 class="mt-1 mb-0">1.736</h5>
                                </div>
                                <div class="ms-auto text-end">
                                    <div class="dropdown icon-dropdown">
                                        <button class="btn dropdown-toggle" id="incomedropdown" type="button"
                                            data-bs-toggle="dropdown" aria-expanded="false"><i
                                                class="icon-more-alt"></i></button>
                                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="incomedropdown">
                                            <a class="dropdown-item" href="#">Today</a><a class="dropdown-item"
                                                href="#">Tomorrow</a><a class="dropdown-item"
                                                href="#">Yesterday </a>
                                        </div>
                                    </div><span class="f-w-600 font-success">+3,7%</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-3 statistic-icon">
                            <div class="light-card balance-card widget-hover">
                                <div class="icon-box"><img
                                        src="{{ asset('assets/images/dashboard/icon/revenue.png') }}" alt="">
                                </div>
                                <div> <span class="f-w-500 f-light">New Leads</span>
                                    <h5 class="mt-1 mb-0">$9.247 </h5>
                                </div>
                                <div class="ms-auto text-end">
                                    <div class="dropdown icon-dropdown">
                                        <button class="btn dropdown-toggle" id="expensedropdown" type="button"
                                            data-bs-toggle="dropdown" aria-expanded="false"><i
                                                class="icon-more-alt"></i></button>
                                        <div class="dropdown-menu dropdown-menu-end"
                                            aria-labelledby="expensedropdown"><a class="dropdown-item"
                                                href="#">Today</a><a class="dropdown-item"
                                                href="#">Tomorrow</a><a class="dropdown-item"
                                                href="#">Yesterday </a></div>
                                    </div><span class="f-w-600 font-danger">-0,10%</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-3 statistic-icon">
                            <div class="light-card balance-card widget-hover">
                                <div class="icon-box"><img
                                        src="{{ asset('assets/images/dashboard/icon/profit.png') }}" alt="">
                                </div>
                                <div> <span class="f-w-500 f-light">Policies Sold</span>
                                    <h5 class="mt-1 mb-0">80%</h5>
                                </div>
                                <div class="ms-auto text-end">
                                    <div class="dropdown icon-dropdown">
                                        <button class="btn dropdown-toggle" id="cashbackdropdown" type="button"
                                            data-bs-toggle="dropdown" aria-expanded="false"><i
                                                class="icon-more-alt"></i></button>
                                        <div class="dropdown-menu dropdown-menu-end"
                                            aria-labelledby="cashbackdropdown"><a class="dropdown-item"
                                                href="#">Today</a><a class="dropdown-item"
                                                href="#">Tomorrow</a><a class="dropdown-item"
                                                href="#">Yesterday </a></div>
                                    </div><span class="f-w-600 font-success">+11,6%</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="chart-dash-2-line"></div>
                </div>
            </div>
        </div>

        <div class="col-xl-5 col-xl-100 col-md-6 proorder-md-12">
            <div class="card">
                <div class="card-header card-no-border pb-0">
                    <div class="header-top">
                        <h4>Upcoming Appointments</h4>
                        <div class="dropdown icon-dropdown">
                            <button class="btn dropdown-toggle" id="userdropdown29" type="button"
                                data-bs-toggle="dropdown" aria-expanded="false"><i
                                    class="icon-more-alt"></i></button>
                            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown29"><a
                                    class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                    href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body overflow-auto theme-scrollbar">
                    <div class="timeline-calendar custom-scrollbar">
                        <div class="custom-calendar" id="calendar-container">
                            <div class="time-line" id="calendar"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-6 col-md-12 col-sm-12 box-col-12">
            <div class="card">
                <div class="card-header">
                    <h4>Policy Growth Line Chart</h4>
                </div>
                <div class="card-body">
                    <div class="ct-4 flot-chart-container"></div>
                </div>
            </div>
        </div>

        <div class="col-xl-6 col-xl-50 col-md-12 proorder-md-2">
            <div class="card">
                <div class="card-header card-no-border">
                    <div class="header-top">
                        <h4>Total Claims</h4>
                        <div class="dropdown icon-dropdown">
                            <button class="btn dropdown-toggle" id="userdropdown7" type="button"
                                data-bs-toggle="dropdown" aria-expanded="false"><i
                                    class="icon-more-alt"></i></button>
                            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown7"><a
                                    class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                    href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body total-project">
                    <h5 class="f-w-500">Currently Running<span class="px-2 f-w-500 font-primary">28 Projects</span>
                    </h5>
                    <div id="total-project"></div>
                    <ul>
                        <li class="d-flex align-items-center gap-2"> <span class="bg-primary"></span>
                            <p>Completed</p>
                        </li>
                        <li class="d-flex align-items-center gap-2"><span class="bg-secondary"></span>
                            <p>In Progress</p>
                        </li>
                        <li class="d-flex align-items-center gap-2"><span class="bg-warning"></span>
                            <p>Terminated</p>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Container-fluid Ends-->
@endsection

@section('scripts')
<script src="{{ asset('assets/js/chart/apex-chart/apex-chart.js') }}"></script>
<script src="{{ asset('assets/js/chart/apex-chart/stock-prices.js') }}"></script>
<script src="{{ asset('assets/js/chart/apex-chart/moment.min.js') }}"></script>
<script src="{{ asset('assets/js/notify/bootstrap-notify.min.js') }}"></script>
<!-- calendar js-->
<script src="{{ asset('assets/js/dashboard/default.js') }}"></script>
<script src="{{ asset('assets/js/notify/index.js') }}"></script>
<script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
<script src="{{ asset('assets/js/datatable/datatables/datatable.custom1.js') }}"></script>
<script src="{{ asset('assets/js/datepicker/date-range-picker/moment.min.js') }}"></script>
<script src="{{ asset('assets/js/datepicker/date-range-picker/datepicker-range-custom.js') }}"></script>
<script src="{{ asset('assets/js/typeahead/handlebars.js') }}"></script>
<script src="{{ asset('assets/js/typeahead/typeahead.bundle.js') }}"></script>
<script src="{{ asset('assets/js/typeahead/typeahead.custom.js') }}"></script>
<script src="{{ asset('assets/js/typeahead-search/handlebars.js') }}"></script>




<!-- calendar js-->
<script src="{{ asset('assets/js/calendar/fullcalender.js') }}"></script>
<script src="{{ asset('assets/js/calendar/custom-calendar.js') }}"></script>

<script src="{{ asset('assets/js/chart/morris-chart/raphael.js') }}"></script>
<script src="{{ asset('assets/js/chart/morris-chart/morris.js') }}"></script>
<script src="{{ asset('assets/js/chart/morris-chart/prettify.min.js') }}"></script>
<script src="{{ asset('assets/js/chart/apex-chart/apex-chart.js') }}"></script>
<script src="{{ asset('assets/js/chart/apex-chart/stock-prices.js') }}"></script>
<script src="{{ asset('assets/js/chart/apex-chart/moment.min.js') }}"></script>
<script src="{{ asset('assets/js/chart/echart/pie-chart/facePrint.js') }}"></script>
<script src="{{ asset('assets/js/chart/echart/pie-chart/testHelper.js') }}"></script>
<script src="{{ asset('assets/js/chart/echart/pie-chart/custom-transition-texture.js') }}"></script>
<script src="{{ asset('assets/js/chart/echart/data/symbols.js') }}"></script>
<script src="{{ asset('assets/js/slick/slick-theme.js') }}"></script>
<script src="{{ asset('assets/js/vector-map/jquery-jvectormap-2.0.2.min.js') }}"></script>
<script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-world-mill-en.js') }}"></script>
<script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-us-aea-en.js') }}"></script>
<script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-uk-mill-en.js') }}"></script>
<script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-au-mill.js') }}"></script>
<script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-chicago-mill-en.js') }}"></script>
<script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-in-mill.js') }}"></script>
<script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-asia-mill.js') }}"></script>


<script src="{{ asset('assets/js/datepicker/date-picker/datepicker.js') }}"></script>
<script src="{{ asset('assets/js/datepicker/date-picker/datepicker.en.js') }}"></script>
<script src="{{ asset('assets/js/datepicker/date-picker/datepicker.custom.js') }}"></script>
<script src="{{ asset('assets/js/rating/jquery.barrating.js') }}"></script>
<script src="{{ asset('assets/js/rating/rating-script.js') }}"></script>
<script src="{{ asset('assets/js/owlcarousel/owl.carousel.js') }}"></script>
<script src="{{ asset('assets/js/vector-map/map-vector.js') }}"></script>
<script src="{{ asset('assets/js/countdown.js') }}"></script>
<script src="{{ asset('assets/js/dashboard/dashboard_3.js') }}"></script>
<script src="{{ asset('assets/js/dashboard/dashboard_2.js') }}"></script>
<script src="{{ asset('assets/js/ecommerce.js') }}"></script>
<script src="{{ asset('assets/js/typeahead/handlebars.js') }}"></script>
<script src="{{ asset('assets/js/typeahead/typeahead.bundle.js') }}"></script>
<script src="{{ asset('assets/js/typeahead/typeahead.custom.js') }}"></script>

<script src="{{ asset('assets/js/typeahead-search/typeahead-custom.js') }}"></script>

<script src="{{ asset('assets/js/height-equal.js') }}"></script>
<script src="{{ asset('assets/js/animation/wow/wow.min.js') }}"></script>






<!-- Chart -->

<script src="{{ asset('assets/js/chart/chartist/chartist.js') }}"></script>
<script src="{{ asset('assets/js/chart/chartist/chartist-plugin-tooltip.js') }}"></script>
<script src="{{ asset('assets/js/chart/chartist/chartist-custom.js') }}"></script>

<!-- Chart End-->

<script>
    new WOW().init();
</script>
@endsection