@extends('layouts.master')

@section('title', 'Blog Single')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Blog Single</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Blog</li>
                <li class="breadcrumb-item f-w-400 active">Blog Single</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="blog-single">
                            <div class="blog-box blog-details"><img class="img-fluid w-100"
                                    src="{{ asset('assets/images/blog/blog-single.jpg') }}" alt="blog-main">
                                <div class="blog-details">
                                    <ul class="blog-social">
                                        <li>25 July 2024</li>
                                        <li><i class="icofont icofont-user"></i>Mark Jecno </li>
                                        <li><i class="icofont icofont-thumbs-up"></i>02 Hits</li>
                                        <li><i class="icofont icofont-ui-chat"></i>598 Comments</li>
                                    </ul>
                                    <h4 class="pt-3 mt-0">The Harpeth rises in the westernmost part of Rutherford County,
                                        just to the east of the community of College Grove in eastern Williamson County.
                                    </h4>
                                    <div class="single-blog-content-top">
                                        <p>From the east coast to the west, each river has its own beauty and character.
                                            Each river has its own story. Take a look at some America’s best rivers and some
                                            of the rivers we’re working to protect. And learn some facts about your favorite
                                            rivers. The Harpeth River and its tributaries are home to rich freshwater
                                            biodiversity, including more than 50 species of fish and 30 species of mussels
                                        </p>
                                        <p>The Harpeth River flows through the heart of downtown Franklin, the 14th fastest
                                            growing city in the United States, and traverses Williamson County, one of the
                                            fastest growing counties in Tennessee. This rapid development has already caused
                                            harm to the river from adding treated sewage, increasing stormwater runoff, and
                                            withdrawing water.The river’s impairment is caused by dangerously low levels of
                                            dissolved oxygen driven by high concentrations of nutrients – particularly
                                            phosphorus – that fuel oxygen-hungry algal blooms that can lead to toxic
                                            conditions.</p>
                                    </div>
                                </div>
                            </div>
                            <section class="comment-box pb-0">
                                <h4>Comment</h4>
                                <hr>
                                <ul>
                                    <li>
                                        <div class="d-flex align-self-center"><img class="align-self-center"
                                                src="{{ asset('assets/images/blog/comment.jpg') }}"
                                                alt="Generic placeholder image">
                                            <div class="flex-grow-1">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <h6 class="mt-0">Jolio Mark<span> ( Designer )</span></h6>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <ul class="comment-social float-start float-md-end">
                                                            <li><i class="icofont icofont-thumbs-up"></i>02 Hits</li>
                                                            <li><i class="icofont icofont-ui-chat"></i>598 Comments</li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <p>To create aesthetically striking photos, one must have a strong grasp of
                                                    composition and lighting in addition to technical proficiency and
                                                    creative vision. A professional photographer has to have an excellent
                                                    eye for detail and be able to tell stories and convey emotions via their
                                                    images.</p>
                                            </div>
                                        </div>
                                    </li>
                                    <li>
                                        <ul>
                                            <li>
                                                <div class="d-flex"><img class="align-self-center"
                                                        src="{{ asset('assets/images/blog/9.jpg') }}"
                                                        alt="Generic placeholder image">
                                                    <div class="flex-grow-1">
                                                        <div class="row">
                                                            <div class="col-xl-12">
                                                                <h6 class="mt-0">Mark Jolio <span> ( Designer )</span>
                                                                </h6>
                                                            </div>
                                                        </div>
                                                        <p>They meticulously plan each shot, considering factors such as
                                                            lighting, angles, and props to convey the desired message
                                                            effectively. Commercial photographers are adept at using their
                                                            technical expertise to highlight the unique features and
                                                            qualities of their subjects, often manipulating lighting and
                                                            post-processing techniques to achieve the desired aesthetic.</p>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </li>
                                    <li>
                                        <div class="d-flex"><img class="align-self-center"
                                                src="{{ asset('assets/images/blog/4.jpg') }}"
                                                alt="Generic placeholder image">
                                            <div class="flex-grow-1">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <h6 class="mt-0">Jhon Deo<span> ( Designer )</span></h6>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <ul class="comment-social float-start float-md-end">
                                                            <li><i class="icofont icofont-thumbs-up"></i>02 Hits</li>
                                                            <li><i class="icofont icofont-ui-chat"></i>598 Comments</li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <p>To create aesthetically striking photos, one must have a strong grasp of
                                                    composition and lighting in addition to technical proficiency and
                                                    creative vision. A professional photographer has to have an excellent
                                                    eye for detail and be able to tell stories and convey emotions via their
                                                    images.</p>
                                            </div>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="d-flex"><img class="align-self-center"
                                                src="{{ asset('assets/images/blog/12.png') }}"
                                                alt="Generic placeholder image">
                                            <div class="flex-grow-1">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <h6 class="mt-0">Mark Ateer<span> ( Designer )</span></h6>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <ul class="comment-social float-start float-md-end">
                                                            <li><i class="icofont icofont-thumbs-up"></i>02 Hits</li>
                                                            <li><i class="icofont icofont-ui-chat"></i>598 Comments</li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <p>They meticulously plan each shot, considering factors such as lighting,
                                                    angles, and props to convey the desired message effectively. Commercial
                                                    photographers are adept at using their technical expertise to highlight
                                                    the unique features and qualities of their subjects, often manipulating
                                                    lighting and post-processing techniques to achieve the desired
                                                    aesthetic.</p>
                                            </div>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="d-flex"><img class="align-self-center"
                                                src="{{ asset('assets/images/blog/14.png') }}"
                                                alt="Generic placeholder image">
                                            <div class="flex-grow-1">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <h6 class="mt-0">Greg Arias<span> ( Designer )</span></h6>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <ul class="comment-social float-start float-md-end">
                                                            <li><i class="icofont icofont-thumbs-up"></i>02 Hits</li>
                                                            <li><i class="icofont icofont-ui-chat"></i>598 Comments</li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <p>Web design is a broad field, thus there are many topics to discuss and
                                                    factors to take into account. It suggests that the look, layout, overall
                                                    ambience, content, user experience, and accessibility have all been
                                                    successfully integrated. To satisfy the timeline and the clients'
                                                    expectations, hundreds of different yet related jobs must be completed.
                                                </p>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </section>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')

@endsection
