@extends('layouts.master')

@section('title', 'Cart')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Cart</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Ecommerce</li>
                <li class="breadcrumb-item f-w-400 active">Cart</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Cart</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="order-history table-responsive wishlist theme-scrollbar">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Prdouct</th>
                                            <th>Prdouct Name</th>
                                            <th>Price</th>
                                            <th>Quantity</th>
                                            <th>Action</th>
                                            <th>Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center"><img class="img-fluid img-40"
                                                    src="{{ asset('assets/images/product/1.png') }}" alt="#"></td>
                                            <td>
                                                <div class="product-name"><a href="#">Long Top</a></div>
                                            </td>
                                            <td>$21</td>
                                            <td>
                                                <fieldset class="qty-box">
                                                    <div class="input-group">
                                                        <input class="touchspin text-center" type="text" value="5">
                                                    </div>
                                                </fieldset>
                                            </td>
                                            <td><i data-feather="x-circle"></i></td>
                                            <td>$12456</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center"><img class="img-fluid img-40"
                                                    src="{{ asset('assets/images/product/13.png') }}" alt="#"></td>
                                            <td>
                                                <div class="product-name"><a href="#">Fancy watch</a></div>
                                            </td>
                                            <td>$50</td>
                                            <td>
                                                <fieldset class="qty-box">
                                                    <div class="input-group">
                                                        <input class="touchspin text-center" type="text" value="5">
                                                    </div>
                                                </fieldset>
                                            </td>
                                            <td><i data-feather="x-circle"></i></td>
                                            <td>$12456</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center"><img class="img-fluid img-40"
                                                    src="{{ asset('assets/images/product/4.png') }}" alt="#"></td>
                                            <td>
                                                <div class="product-name"><a href="#">Man shoes</a></div>
                                            </td>
                                            <td>$11</td>
                                            <td>
                                                <fieldset class="qty-box">
                                                    <div class="input-group">
                                                        <input class="touchspin text-center" type="text" value="5">
                                                    </div>
                                                </fieldset>
                                            </td>
                                            <td><i data-feather="x-circle"></i></td>
                                            <td>$12456</td>
                                        </tr>
                                        <tr>
                                            <td colspan="4">
                                                <div class="input-group">
                                                    <input class="form-control me-2" type="text"
                                                        placeholder="Enter coupan code"><a class="btn btn-primary"
                                                        href="#">Apply</a>
                                                </div>
                                            </td>
                                            <td class="total-amount">
                                                <h5 class="m-0 text-end"><span class="f-w-600">Total Price :</span></h5>
                                            </td>
                                            <td><span>$6935.00 </span></td>
                                        </tr>
                                        <tr>
                                            <td class="text-end" colspan="5"><a
                                                    class="btn btn-secondary cart-btn-transform"
                                                    href="{{ route('admin.product') }}">continue shopping</a></td>
                                            <td><a class="btn btn-success cart-btn-transform"
                                                    href="{{ route('admin.checkout') }}">check
                                                    out</a></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <!-- calendar js-->
    <script src="{{ asset('assets/js/touchspin/vendors.min.js') }}"></script>
    <script src="{{ asset('assets/js/touchspin/touchspin.js') }}"></script>
    <script src="{{ asset('assets/js/touchspin/input-groups.min.js') }}"></script>
@endsection
