@extends('layouts.master')

@section('title', 'File Manager')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">File Manager</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Apps</li>
                <li class="breadcrumb-item f-w-400 active">File Manager</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-3 box-col-30">
                <div class="md-sidebar job-sidebar"><a class="btn btn-primary md-sidebar-toggle"
                        href="javascript:void(0)">file filter</a>
                    <div class="md-sidebar-aside custom-scrollbar">
                        <div class="file-sidebar">
                            <div class="card theme-scrollbar">
                                <div class="card-body">
                                    <ul>
                                        <li>
                                            <div class="btn btn-primary"><i data-feather="home"> </i>Home </div>
                                        </li>
                                        <li>
                                            <div class="btn btn-light"><i data-feather="folder"></i>All </div>
                                        </li>
                                        <li>
                                            <div class="btn btn-light"><i data-feather="clock"></i>Recent </div>
                                        </li>
                                        <li>
                                            <div class="btn btn-light"><i data-feather="star"></i>Starred </div>
                                        </li>
                                        <li>
                                            <div class="btn btn-light"><i data-feather="alert-circle"></i>Recovery </div>
                                        </li>
                                        <li>
                                            <div class="btn btn-light"><i data-feather="trash-2"></i>Deleted </div>
                                        </li>
                                    </ul>
                                    <hr>
                                    <ul>
                                        <li>
                                            <div class="btn btn-outline-primary"><i data-feather="database"> </i>Storage
                                            </div>
                                            <div class="m-t-15">
                                                <div class="progress sm-progress-bar mb-3">
                                                    <div class="progress-bar bg-primary" role="progressbar"
                                                        style="width: 25%" aria-valuenow="25" aria-valuemin="0"
                                                        aria-valuemax="100"></div>
                                                </div>
                                                <h6 class="f-w-500">25 GB of 100 GB used</h6>
                                            </div>
                                        </li>
                                    </ul>
                                    <hr>
                                    <ul>
                                        <li>
                                            <div class="btn btn-outline-primary"><i data-feather="grid"> </i>Pricing plan
                                            </div>
                                        </li>
                                        <li>
                                            <div class="pricing-plan">
                                                <h6>Trial Version </h6>
                                                <h5>FREE</h5>
                                                <p>100 GB Space</p>
                                                <div class="btn btn-outline-primary btn-xs">Selected</div><img
                                                    class="bg-img" src="{{ asset('assets/images/dashboard/folder.png') }}"
                                                    alt="">
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-9 col-md-12 box-col-12">
                <div class="file-content">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-md-flex d-sm-block">
                                <form class="form-inline" action="#" method="get">
                                    <div class="form-group d-flex align-items-center mb-0"> <i class="fa fa-search"></i>
                                        <input class="form-control-plaintext" type="text" placeholder="Search...">
                                    </div>
                                </form>
                                <div class="flex-grow-1 text-end">
                                    <form class="d-inline-flex" action="#" method="POST" enctype="multipart/form-data"
                                        name="myForm">
                                        <div class="btn btn-primary" onclick="getFile()"> <i
                                                data-feather="plus-square"></i>Add New</div>
                                        <div style="height: 0px;width: 0px; overflow:hidden;">
                                            <input id="upfile" type="file" onchange="sub(this)">
                                        </div>
                                    </form>
                                    <div class="btn btn-outline-primary ms-2"><i data-feather="upload"> </i>Upload </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body file-manager">
                            <h5 class="mb-2">Quick Access </h5>
                            <ul class="quick-file d-flex flex-row">
                                <li>
                                    <div class="quick-box"><i class="fa fa-youtube-play font-danger"></i></div>
                                    <h6>Videos</h6>
                                </li>
                                <li>
                                    <div class="quick-box"><i class="fa fa-th font-info"></i></div>
                                    <h6>Apps</h6>
                                </li>
                                <li>
                                    <div class="quick-box"><i class="fa fa-file-text-o font-secondary"></i></div>
                                    <h6>Document</h6>
                                </li>
                                <li>
                                    <div class="quick-box"><i class="fa fa-music font-warning"></i></div>
                                    <h6>Music</h6>
                                </li>
                                <li>
                                    <div class="quick-box"><i class="fa fa-download font-primary"></i></div>
                                    <h6>Download</h6>
                                </li>
                                <li>
                                    <div class="quick-box"><i class="fa fa-folder font-info"></i></div>
                                    <h6>Folder</h6>
                                </li>
                                <li>
                                    <div class="quick-box"><i class="fa fa-file-archive-o font-secondary"></i></div>
                                    <h6>Zip File</h6>
                                </li>
                                <li>
                                    <div class="quick-box"><i class="fa fa-trash font-danger"></i></div>
                                    <h6>Trash</h6>
                                </li>
                            </ul>
                            <h5 class="mt-4 mb-2">Folders</h5>
                            <ul class="folder">
                                <li class="folder-box">
                                    <div class="d-block"><i class="f-44 fa fa-file-archive-o txt-warning"></i><i
                                            class="fa fa-ellipsis-v me-0 f-14 ellips"></i>
                                        <div class="mt-3">
                                            <h6>Tivo admin</h6>
                                            <p>20 file<span class="pull-right"> <i class="fa fa-clock-o"> </i> 2 Hour
                                                    ago</span></p>
                                        </div>
                                    </div>
                                </li>
                                <li class="folder-box">
                                    <div class="d-block"><i class="f-44 fa fa-folder txt-warning"></i><i
                                            class="fa fa-ellipsis-v me-0 f-14 ellips"></i>
                                        <div class="mt-3">
                                            <h6>Viho admin</h6>
                                            <p>14 file<span class="pull-right"> <i class="fa fa-clock-o"> </i> 3 Hour
                                                    ago</span></p>
                                        </div>
                                    </div>
                                </li>
                                <li class="folder-box">
                                    <div class="d-block"><i class="f-44 fa fa-file-archive-o txt-warning"></i><i
                                            class="fa fa-ellipsis-v me-0 f-14 ellips"></i>
                                        <div class="mt-3">
                                            <h6>Unice admin</h6>
                                            <p>15 file<span class="pull-right"> <i class="fa fa-clock-o"> </i> 3 Day
                                                    ago</span></p>
                                        </div>
                                    </div>
                                </li>
                                <li class="folder-box">
                                    <div class="d-block"><i class="f-44 fa fa-folder txt-warning"></i><i
                                            class="fa fa-ellipsis-v me-0 f-14 ellips"></i>
                                        <div class="mt-3">
                                            <h6>Koho admin</h6>
                                            <p>10 file<span class="pull-right"> <i class="fa fa-clock-o"> </i> 1 Day
                                                    ago</span></p>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                            <h5 class="mt-4 mb-2">Files </h5>
                            <ul class="d-flex flex-row files-content">
                                <li class="folder-box d-flex align-items-center">
                                    <div class="d-flex align-items-center files-list">
                                        <div class="flex-shrink-0 file-left"><i class="f-22 fa fa-folder font-info"></i>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <h6>Logo.psd</h6>
                                            <p>7 Hour ago, 2.0 MB</p>
                                        </div>
                                    </div>
                                </li>
                                <li class="folder-box d-flex align-items-center">
                                    <div class="d-flex align-items-center files-list">
                                        <div class="flex-shrink-0 file-left"><i
                                                class="f-22 fa fa-file-excel-o font-success"></i></div>
                                        <div class="flex-grow-1 ms-3">
                                            <h6>Backend.xls</h6>
                                            <p>2 Day ago, 3.0 GB</p>
                                        </div>
                                    </div>
                                </li>
                                <li class="folder-box d-flex align-items-center">
                                    <div class="d-flex align-items-center files-list">
                                        <div class="flex-shrink-0 file-left"><i
                                                class="f-22 fa fa-file-archive-o font-warning"></i></div>
                                        <div class="flex-grow-1 ms-3">
                                            <h6>Project.zip</h6>
                                            <p>1 Day ago, 1.9 GB</p>
                                        </div>
                                    </div>
                                </li>
                                <li class="folder-box d-flex align-items-center">
                                    <div class="d-flex align-items-center files-list">
                                        <div class="flex-shrink-0 file-left"><i
                                                class="f-22 fa fa-folder font-primary"></i></div>
                                        <div class="flex-grow-1 ms-3">
                                            <h6>Report.txt</h6>
                                            <p>1 Day ago, 0.9 KB</p>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <!-- calendar js-->
    <script src="{{ asset('assets/js/icons/feather-icon/feather-icon-clipart.js') }}"></script>
    <script src="{{ asset('assets/js/typeahead/handlebars.js') }}"></script>
    <script src="{{ asset('assets/js/typeahead/typeahead.bundle.js') }}"></script>
    <script src="{{ asset('assets/js/typeahead/typeahead.custom.js') }}"></script>
    <script src="{{ asset('assets/js/typeahead-search/handlebars.js') }}"></script>
    <script src="{{ asset('assets/js/typeahead-search/typeahead-custom.js') }}"></script>
@endsection
