@extends('layouts.master')

@section('title', 'Map JS')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/leaflet.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Map JS</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Maps</li>
                <li class="breadcrumb-item f-w-400 active">Map JS</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Map at a specified location</h4><span>Display a map at a specified location and zoom
                            level.</span>
                    </div>
                    <div class="card-body map-z-index">
                        <div class="map-js-height" id="weathermap"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Map using View Bounds</h4><span>Display a map of a given area.</span>
                    </div>
                    <div class="card-body map-z-index">
                        <div class="map-js-height" id="map2"> </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <!-- calendar js-->
    <script src="{{ asset('assets/js/map-js/leaflet.js') }}"></script>
    <script src="{{ asset('assets/js/map-js/custom.js') }}"></script>
    <script src="{{ asset('assets/js/map-js/map-custom2.js') }}"></script>
@endsection
