@extends('layouts.master')

@section('title', 'Vector Maps')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/vector-map.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Vector Maps</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Maps</li>
                <li class="breadcrumb-item f-w-400 active">Vector Maps</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-6">
                <div class="card">
                    <div class="card-header">
                        <h4>VECTOR WORLD MAP</h4><span>Below Map is displaying the world map.</span>
                    </div>
                    <div class="card-body">
                        <div class="jvector-map-height" id="world-map"></div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="card">
                    <div class="card-header">
                        <h4>VECTOR USA MAP</h4><span>Below Map is displaying the usa map.</span>
                    </div>
                    <div class="card-body">
                        <div class="jvector-map-height" id="usa"></div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="card">
                    <div class="card-header">
                        <h4>VECTOR CANADA MAP</h4><span>Below Map is displaying the canada map.</span>
                    </div>
                    <div class="card-body">
                        <div class="jvector-map-height" id="canada"></div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="card">
                    <div class="card-header">
                        <h4>VECTOR INDIA MAP</h4><span>Below Map is displaying the india map.</span>
                    </div>
                    <div class="card-body">
                        <div class="jvector-map-height" id="india"></div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="card">
                    <div class="card-header">
                        <h4>VECTOR ASIA MAP</h4><span>Below Map is displaying the asia map.</span>
                    </div>
                    <div class="card-body">
                        <div class="jvector-map-height" id="asia"></div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="card">
                    <div class="card-header">
                        <h4>VECTOR CANADA MAP</h4><span>Below Map is displaying the uk map.</span>
                    </div>
                    <div class="card-body">
                        <div class="jvector-map-height" id="uk"></div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="card">
                    <div class="card-header">
                        <h4>VECTOR CHICAGO MAP</h4><span>Below Map is displaying the chicago map.</span>
                    </div>
                    <div class="card-body">
                        <div class="jvector-map-height" id="chicago"></div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="card">
                    <div class="card-header">
                        <h4>VECTOR AUSTRALIA MAP</h4><span>Below Map is displaying the australia map.</span>
                    </div>
                    <div class="card-body">
                        <div class="jvector-map-height" id="australia"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <script src="{{ asset('assets/js/vector-map/jquery-jvectormap-2.0.2.min.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-world-mill-en.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-us-aea-en.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-uk-mill-en.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-au-mill.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-chicago-mill-en.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-in-mill.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-asia-mill.js') }}"></script>
    <!-- calendar js-->
    <script src="{{ asset('assets/js/vector-map/map-vector.js') }}"></script>
@endsection
