<?php $__env->startSection('title', 'Claims List'); ?>

<?php $__env->startSection('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/quill.snow.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/animate.css')); ?>">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@1.6.2/dist/select2-bootstrap4.min.css"
    rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/min/dropzone.min.css" />
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
<style>
/* Custom progress bar colors for each type */
.toast-success .toast-progress {
    background-color: #198754;
}

.toast-error .toast-progress {
    background-color: #dc3545;
}

.toast-info .toast-progress {
    background-color: #0dcaf0;
}

.toast-warning .toast-progress {
    background-color: #ffc107;
}

#mini-map {
    height: 300px;
    border: 1px solid #ccc;
    border-radius: 8px;
    margin-top: 10px;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
<div class="header-logo-wrapper col-auto">
    <div class="logo-wrapper"><a href="<?php echo e(route('admin.dashboard')); ?>"><img class="img-fluid for-light"
                src="<?php echo e(asset('assets/images/logo/logo.png')); ?>" alt="" /><img class="img-fluid for-dark"
                src="<?php echo e(asset('assets/images/logo/logo_light.png')); ?>" alt="" /></a></div>
</div>
<div class="col-4 col-xl-4 page-title">
    <h4 class="f-w-700">Claim</h4>
    <nav>
        <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"> <i data-feather="home"> </i></a></li>
            <li class="breadcrumb-item f-w-400">Claims</li>
            <li class="breadcrumb-item f-w-400 active">List</li>
        </ol>
    </nav>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
<!-- Container-fluid starts-->
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header pb-0 card-no-border">
                    <h4>Claims Table</h4>
                    <span>Manage and view submitted insurance claims here.</span>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
    <div class="col-md-3">
        <select id="statusFilter" class="form-control">
            <option value="">All Status</option>
            <option value="pending">Pending</option>
            <option value="reviewed">Reviewed</option>
            <option value="approved">Approved</option>
            <option value="settled">Settled</option>
        </select>
    </div>
    <div class="col-md-3">
        <input type="date" id="startDate" class="form-control" placeholder="Start Date">
    </div>
    <div class="col-md-3">
        <input type="date" id="endDate" class="form-control" placeholder="End Date">
    </div>
</div>
                    <div class="dt-ext table-responsive theme-scrollbar">
                        <table id="claims-table" class="display" id="keytable">
    <thead>
        <tr>
            <th>Claim Number</th>
            <th>Policy Number</th>
            <th>Customer Name</th>
            <th>Claim Type</th>
            <th>Status</th>
            <th>Progress</th>
            <th>Incident Date</th>
            <th>Claim Amount</th>
            <th>Submitted At</th>

        </tr>
    </thead>
                            <tbody>

                            </tbody>

                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Approve Modal -->

<div class="modal fade" id="approveModal" tabindex="-1" aria-labelledby="approveModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="approveClaimForm" method="POST">
      <?php echo csrf_field(); ?>
      <?php echo method_field('PATCH'); ?> <!-- or POST, depending on your route -->
      <input type="hidden" name="claim_id" id="claim_id" value="">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="approveModalLabel">Approve Claim</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          Are you sure you want to approve this claim?
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-success">Approve</button>
        </div>
      </div>
    </form>
  </div>
</div>







<!-- Container-fluid Ends-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<!-- calendar js-->
<script src="<?php echo e(asset('assets/js/datatable/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/jszip.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/buttons.colVis.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.autoFill.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.select.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/responsive.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.keyTable.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.colReorder.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.fixedHeader.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.rowReorder.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.scroller.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatable-extension/custom.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/tooltip-init.js')); ?>"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css" />

<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

<!-- For exporting excel/pdf (optional) -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>

<script>
$(function () {
    const table = $('#claims-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "<?php echo e(route('admin.claims.data')); ?>",
            data: function (d) {
                d.status = $('#statusFilter').val();
                d.start_date = $('#startDate').val();
                d.end_date = $('#endDate').val();
            }
        },
        columns: [
            { data: 'claim_number' },
            { data: 'policy_number' },
            { data: 'customer_name' },
            { data: 'claim_type' },
               { data: 'status_pill', title: 'Status', orderable: false, searchable: false },
            { data: 'progress', title: 'Progress', orderable: false, searchable: false },

            { data: 'submitted_at' },
            { data: 'claim_amount_requested' },
             { data: 'action', title: 'Actions', orderable: false, searchable: false }
             ],
        dom: 'Brtip',
        buttons: ['csv', 'excel', 'pdf'],
        pageLength: 10
    });

    $('#statusFilter, #startDate, #endDate').on('change', function () {
        table.draw();
    });
});
</script>
<script>

    const approveModal = document.getElementById('approveModal');
approveModal.addEventListener('show.bs.modal', function (event) {
  const button = event.relatedTarget; // The clicked link/button
  const claimId = button.getAttribute('data-id');

  // Set the hidden input value
  const claimIdInput = approveModal.querySelector('#claim_id');
  claimIdInput.value = claimId;

  // Also set the form action dynamically (replace with your route pattern)
  const form = approveModal.querySelector('#approveClaimForm');
  form.action = `/admin/claims/${claimId}/approve`;
});
$(document).ready(function () {
    let approveUrl = '';

    // Trigger modal
    $(document).on('click', '.approve-claim-btn', function () {
        const claimId = $(this).data('id');
        approveUrl = `/admin/claims/${claimId}/approve`;
        $('#approveClaimForm').attr('action', approveUrl);
        $('#approveModal').modal('show');
    });

    // Handle form submission via AJAX
  $('#approveClaimForm').submit(function (e) {
    e.preventDefault();

    const form = this;
    $.ajax({
        url: form.action,
        type: 'PATCH',
        data: $(form).serialize(),
        success: function (res) {
            $('#approveModal').modal('hide');
            // Optionally reload your DataTable or update UI
            toastr.success(res.message);
            $('#claims-table').DataTable().ajax.reload(null, false);
        },
        error: function (xhr) {
            toastr.error('Failed to approve claim');
        }
    });
});

});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/oriontje/crm.oriontechet.com/resources/views/admin/claims/index.blade.php ENDPATH**/ ?>