<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('system_settings', function (Blueprint $table) {
            $table->id();

            // General
            $table->string('system_name')->default('Nyala Insurance CRM');
            $table->string('system_email')->nullable();
            $table->string('system_phone')->nullable();
            $table->string('system_url')->nullable();

            // Branding
            $table->string('logo')->nullable();
            $table->string('favicon')->nullable();
            $table->string('primary_color')->default('#004d99');
            $table->string('secondary_color')->nullable();

            // Localization
            $table->string('default_language')->default('en');
            $table->string('default_timezone')->default('Africa/Addis_Ababa');
            $table->string('currency')->default('ETB');

            // Security
            $table->boolean('2fa_enabled')->default(false);
            $table->boolean('email_verification_required')->default(true);
            $table->integer('session_timeout_minutes')->default(30);

            // Communication preferences
            $table->boolean('enable_email')->default(true);
            $table->boolean('enable_sms')->default(false);
            $table->boolean('enable_push')->default(false);
            $table->json('default_contact_methods')->nullable(); // ['email', 'phone']

            // Notifications
            $table->boolean('enable_notifications')->default(true);
            $table->boolean('daily_summary_enabled')->default(false);

            // Integrations
            $table->boolean('enable_api')->default(true);
            $table->boolean('enable_third_party')->default(false);
            $table->json('enabled_integrations')->nullable(); // ['mailchimp', 'slack']

            // Maintenance
            $table->boolean('maintenance_mode')->default(false);
            $table->text('maintenance_message')->nullable();

            // Advanced
            $table->json('extra_configs')->nullable(); // Flexible key-value pair settings

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('system_settings');
    }
};
