<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('feedback', function (Blueprint $table) {
            $table->id();

            // Who submitted it (can be polymorphic: users or corporate customers)
            $table->nullableMorphs('submitter'); // 'submitter_id', 'submitter_type'

            // Feedback context
            $table->enum('category', ['complaint', 'suggestion', 'praise', 'inquiry', 'other'])->default('other');
            $table->string('subject')->nullable();
            $table->text('message');
            $table->string('related_module')->nullable(); // e.g., 'claims', 'policies', 'login', etc.
            $table->unsignedBigInteger('related_entity_id')->nullable(); // e.g., policy ID, claim ID

            // Feedback tracking
            $table->enum('status', ['new', 'in_review', 'resolved', 'dismissed'])->default('new');
            $table->enum('sentiment', ['positive', 'neutral', 'negative'])->nullable();
            $table->boolean('is_anonymous')->default(false);
            $table->boolean('is_internal')->default(false); // For admin-only visibility

            // Follow-up
            $table->timestamp('responded_at')->nullable();
            $table->unsignedBigInteger('handled_by')->nullable();
            $table->foreign('handled_by')->references('id')->on('users')->nullOnDelete();

            // Attachment support
            $table->json('attachments')->nullable(); // Array of file paths or URLs

            // Location/context
            $table->string('platform')->nullable(); // 'web', 'mobile', 'tablet', etc.
            $table->string('ip_address')->nullable();
            $table->string('browser_agent')->nullable();

            // Audit trail
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('feedback');
    }
};
