<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('calendar_events', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description')->nullable();
            $table->enum('event_type', ['meeting', 'call', 'deadline', 'reminder'])->default('meeting');
            $table->timestamp('start_time');
            $table->timestamp('end_time')->nullable();
            $table->enum('visibility', ['public', 'private'])->default('private');
            $table->foreignId('related_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('related_customer_id')->nullable()->constrained('customers')->nullOnDelete();
            $table->foreignId('related_corporate_customer_id')->nullable()->constrained('corporate_customers')->nullOnDelete();
            $table->timestamps();
            
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('calendar_events');
    }
};
