<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddLocationColumnsToCustomersTable extends Migration
{
    public function up()
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->string('administrative_region_city')->nullable()->after('country');
            $table->string('sub_city_zone')->nullable()->after('administrative_region_city');
            $table->string('wereda_town')->nullable()->after('sub_city_zone');
            $table->string('kebele')->nullable()->after('wereda_town');
        });
    }

    public function down()
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->dropColumn([
                'administrative_region_city',
                'sub_city_zone',
                'wereda_town',
                'kebele',
            ]);
        });
    }
}
