<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            // Primary Key
            $table->bigIncrements('id');

            // Foreign Keys
            $table->foreignId('user_id')->constrained();
            $table->foreignId('policy_id')->constrained();
            $table->foreignId('payment_id')->constrained();

            // Transaction Details
            $table->decimal('amount', 15, 2);
            $table->char('currency', 3)->default('USD');
            $table->enum('transaction_type', ['debit', 'credit']);
            
            // Status & Metadata
            $table->enum('status', ['success', 'failed', 'reversed'])->default('success');
            $table->longText('metadata');
            $table->string('blockchain_hash', 255)->nullable();

            // Timestamps
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrent()->useCurrentOnUpdate();
        });

        // Database-specific configuration
        Schema::table('transactions', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('transactions');
    }
};