<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('customers', function (Blueprint $table) {
            // Primary Key
            $table->bigIncrements('id'); // bigint(20) UNSIGNED NOT NULL

            // Personal Information
            $table->string('first_name', 100);
            $table->string('last_name', 100);
            $table->string('email', 100)->nullable()->unique();
            $table->string('phone', 20)->nullable();
            $table->string('alt_phone', 20)->nullable();
            $table->enum('gender', ['male', 'female', 'other'])->nullable();
            $table->date('date_of_birth')->nullable();

            // Identification
            $table->string('national_id', 50)->nullable()->unique();
            $table->string('passport_number', 50)->nullable()->unique();
            $table->string('tax_id', 50)->nullable()->unique();

            // Address Information
            $table->text('address')->nullable();
            $table->string('city', 100)->nullable();
            $table->string('state', 100)->nullable();
            $table->string('country', 100)->nullable();
            $table->string('postal_code', 20)->nullable();

            // Employment Details
            $table->string('occupation', 100)->nullable();
            $table->string('employer', 255)->nullable();
            $table->decimal('annual_income', 15, 2)->nullable();

            // Business Information
            $table->enum('customer_type', ['individual', 'corporate'])->default('individual');
            $table->string('company_name', 255)->nullable();
            $table->string('industry', 255)->nullable();
            $table->string('business_registration_number', 100)->nullable()->unique();

            // Contact Person (for corporate)
            $table->string('contact_person', 255)->nullable();
            $table->string('contact_person_phone', 20)->nullable();
            $table->string('contact_person_email', 100)->nullable();

            // Authentication & Verification
            $table->string('password', 255)->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->timestamp('phone_verified_at')->nullable();

            // Status
            $table->enum('status', ['active', 'inactive', 'blacklisted'])->default('active');

            // Audit Fields
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('set null');

            // Timestamps
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
            $table->softDeletes();

            // Indexes
            $table->index('created_by', 'idx_created_by');
            $table->index('updated_by', 'idx_updated_by');
        });

        // Explicit database configuration
        Schema::table('customers', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('customers');
    }
};