<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('policy_change_logs', function (Blueprint $table) {
            // Primary Key
            $table->integer('id')->unsigned()->autoIncrement(); // int(11) NOT NULL

            // Foreign Keys
            $table->unsignedBigInteger('policy_id'); // bigint(20) UNSIGNED
            $table->foreign('policy_id')
                  ->references('id')
                  ->on('policies')
                  ->onDelete('cascade');

            $table->unsignedBigInteger('user_id'); // bigint(20) UNSIGNED
            $table->foreign('user_id')
                  ->references('id')
                  ->on('users')
                  ->onDelete('cascade');

            // Change Tracking Fields
            $table->string('field_changed', 255);
            $table->text('old_value')->nullable();
            $table->text('new_value');
            
            // Timestamp
            $table->timestamp('changed_at')->useCurrent();
        });

        // Explicit database configuration
        Schema::table('policy_change_logs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('policy_change_logs');
    }
};