<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;
use Illuminate\Support\Str;

class PolicySeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        // Fetch all customer IDs from the database
        $customerIds = DB::table('customers')->pluck('id');

        // For each customer, create one policy
        foreach ($customerIds as $customerId) {
            // Randomize policy dates
            $startDate = $faker->dateTimeBetween('-1 year', 'now')->format('Y-m-d');
            $endDate = date('Y-m-d', strtotime($startDate . ' +1 year'));
            $issueDate = $faker->dateTimeBetween('-1 year', $startDate)->format('Y-m-d');
            $renewalDate = rand(0, 1) ? date('Y-m-d', strtotime($endDate . ' +1 year')) : null;
            $maturityDate = rand(0, 1) ? date('Y-m-d', strtotime($endDate . ' +5 years')) : null;

            DB::table('policies')->insert([
                'customer_id' => $customerId,
                'corporate_customer_id' => null,
                'policy_number' => 'POL' . $faker->unique()->numerify('########'),
                'policy_type' => $faker->randomElement(['Motor', 'Health', 'Life', 'Travel']),
                'coverage_type' => $faker->randomElement(['individual', 'family', 'group']),
                'policy_name' => $faker->randomElement(['Motor Cover', 'Life Shield', 'Health Plus']),
                'description' => rand(0, 1) ? $faker->sentence : null,
                'start_date' => $startDate,
                'end_date' => $endDate,
                'issue_date' => $issueDate,
                'maturity_date' => $maturityDate,
                'renewal_date' => $renewalDate,
                'sum_assured' => $faker->randomFloat(2, 100000, 5000000),
                'premium_amount' => $faker->randomFloat(2, 500, 10000),
                'premium_frequency' => $faker->randomElement(['monthly', 'quarterly', 'semi-annually', 'annually']),
                'payment_method' => $faker->randomElement(['bank_transfer', 'credit_card', 'cash', 'mobile_money']),
                'auto_renew' => $faker->boolean,
                'status' => $faker->randomElement(['active', 'inactive', 'cancelled', 'expired', 'pending']),
                'cancellation_reason' => null,
                'number_of_beneficiaries' => $faker->numberBetween(0, 5),
                'attachments' => null,
                'notes' => rand(0, 1) ? $faker->sentence : null,
                'source' => $faker->randomElement(['agent', 'branch', 'online', 'referral']),
                'created_by' => 2,
                'updated_by' => 2,
                'created_at' => now(),
                'updated_at' => now(),
                'deleted_at' => null,
            ]);
        }
    }
}
