
(function($) {
   $.fn.clearSearch = function(options) {
       var settings = $.extend({
               'clearClass' : 'clear_input',
               'divClass' : this.clearClass + '_div',
               'focusAfterClear' : true,
               'linkText' : '<i class="icofont icofont-close-circled" title="Clear"></i>'
       }, options);
       return this.each(function() {
                   var $this = $(this), btn;

                   if (!$this.parent().hasClass(settings.divClass)) {
                       //$this.wrap('<div style="position: relative;" class="'
                           //+ settings.divClass + '">' + $this.html() + '</div>');
                       $this.after('<a style="position: absolute; cursor: pointer; left: 328.883px; animation-delay: -2s; !important;" class="'
                           + settings.clearClass + '">' + settings.linkText + '</a>');
                   }
                   btn = $this.next();

                   function clearField() {
                       $this.val('').change();
                       triggerBtn();
                       if (settings.focusAfterClear) {
                           $this.focus();
                       }
                       if (typeof (settings.callback) === "function") {
                           settings.callback();
                       }
                   }

                   function triggerBtn() {
                       if (hasText()) {
                           btn.show();
                   
                          //$(".clearClass").css('cssText', "left: 328.5px; animation-delay: -2s;"); 
                       } else {
                           btn.hide();
                       }
                       update();
                   }

                   function hasText() {
                       return $this.val().replace(/^\s+|\s+$/g, '').length > 0;
                   }

                   function update() {
                       var width = $this.outerWidth(), height = $this
                               .outerHeight();
                       btn.css({
                           top : height / 2 - btn.height() / 2,
                           left : width - height / 2 - btn.height() / 2
                       });
                   }

                   btn.on('click', clearField);
                   $this.on('keyup keydown change focus', triggerBtn);
                   triggerBtn();
               });
   };
})(jQuery);