<h6 class="fw-bold mb-3">Policy Details</h6>
<div class="row">
    <div class="col-md-6">
        <ul class="list-group list-group-flush">
            <li class="list-group-item"><strong>Policy Number:</strong> {{ $policy->policy_number }}</li>
            <li class="list-group-item"><strong>Policy Type:</strong> {{ $policy->policy_type }}</li>
            <li class="list-group-item"><strong>Coverage:</strong> {{ ucfirst($policy->coverage_type) }}</li>
            <li class="list-group-item"><strong>Status:</strong>
                <span class="badge
                    @if($policy->status == 'active') bg-success
                    @elseif($policy->status == 'inactive') bg-secondary
                    @elseif($policy->status == 'cancelled') bg-danger
                    @elseif($policy->status == 'expired') bg-warning
                    @else bg-light text-dark @endif">
                    {{ ucfirst($policy->status) }}
                </span>
            </li>
            <li class="list-group-item"><strong>Start Date:</strong> {{ $policy->start_date }}</li>
            <li class="list-group-item"><strong>End Date:</strong> {{ $policy->end_date }}</li>
        </ul>
    </div>
    <div class="col-md-6">
        <ul class="list-group list-group-flush">
            <li class="list-group-item"><strong>Premium:</strong> {{ number_format($policy->premium_amount, 2) }} ETB</li>
            <li class="list-group-item"><strong>Frequency:</strong> {{ ucfirst($policy->premium_frequency) }}</li>
            <li class="list-group-item"><strong>Payment Method:</strong> {{ ucfirst($policy->payment_method) }}</li>
            <li class="list-group-item"><strong>Auto Renew:</strong> {{ $policy->auto_renew ? 'Yes' : 'No' }}</li>
            <li class="list-group-item"><strong>Created At:</strong> {{ $policy->created_at->format('F j, Y') }}</li>
        </ul>
    </div>
</div>
