@extends('layouts.master')

@section('title', 'Range-slider')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/range-slider.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Range Slider</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Bonus Ui</li>
                <li class="breadcrumb-item f-w-400 active">Range Slider</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="alert txt-primary bg-light-primary alert-dismissible fade show warning-alert" role="alert"><i
                data-feather="alert-triangle"></i>
            <p>This is the range-slider page which uses jQuery <a href="http://ionden.com/a/plugins/ion.rangeSlider"
                    target="_blank">[ http://ionden.com/a/plugins/ion.rangeSlider ]</a></p>
            <button class="btn-close" type="button" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Default Range Slider</h4>
                        <p class="f-m-light mt-1">
                            Use <code>range-slider </code> class. and mofi used Ion range slider.</p>
                    </div>
                    <div class="card-body">
                        <form class="theme-form form-label-align-right range-slider">
                            <div class="form-group row py-1">
                                <div class="col-md-10">
                                    <input id="u-range-01" type="text">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Min Max Value</h4>
                        <p class="f-m-light mt-1">
                            Use <code>range-slider </code> class. and mofi used Ion range slider.</p>
                    </div>
                    <div class="card-body">
                        <div class="form-group row py-1">
                            <div class="col-md-10">
                                <input id="u-range-02" type="text">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Prefix</h4>
                        <p class="f-m-light mt-1">
                            Use <code>range-slider </code> class. and mofi used Ion range slider.</p>
                    </div>
                    <div class="card-body">
                        <div class="form-group row py-1">
                            <div class="col-md-10">
                                <input id="u-range-03" type="text">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Negative Value</h4>
                        <p class="f-m-light mt-1">
                            Use <code>range-slider </code> class. and mofi used Ion range slider.</p>
                    </div>
                    <div class="card-body">
                        <div class="form-group row py-1">
                            <div class="col-md-10">
                                <input id="u-range-04" type="text">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Steps Range Slider</h4>
                        <p class="f-m-light mt-1">
                            Use <code>range-slider </code> class. and mofi used Ion range slider.</p>
                    </div>
                    <div class="card-body">
                        <div class="form-group row py-1">
                            <div class="col-md-10">
                                <input id="u-range-05" type="text">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Custom Values</h4>
                        <p class="f-m-light mt-1">
                            Use <code>range-slider </code> class. and mofi used Ion range slider.</p>
                    </div>
                    <div class="card-body">
                        <div class="form-group row py-1">
                            <div class="col-md-10">
                                <input id="u-range-06" type="text">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Prettify Numbers</h4>
                        <p class="f-m-light mt-1">
                            Use <code>range-slider </code> class. and mofi used Ion range slider.</p>
                    </div>
                    <div class="card-body">
                        <div class="form-group row py-1">
                            <div class="col-md-10">
                                <input id="u-range-07" type="text">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Disabled</h4>
                        <p class="f-m-light mt-1">
                            Use <code>range-slider </code> class. and mofi used Ion range slider.</p>
                    </div>
                    <div class="card-body">
                        <div class="form-group row py-1">
                            <div class="col-md-10">
                                <input id="u-range-08" type="text">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Manipulating UI</h4>
                        <p class="f-m-light mt-1">
                            Use <code>range-slider </code> class. and mofi used Ion range slider.</p>
                    </div>
                    <div class="card-body">
                        <div class="form-group row py-1">
                            <div class="col-md-10">
                                <input id="u-range-09" type="text">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Core UI Text</h4>
                        <p class="f-m-light mt-1">
                            Use <code>range-slider </code> class. and mofi used Ion range slider.</p>
                    </div>
                    <div class="card-body">
                        <div class="form-group row py-1">
                            <div class="col-md-10">
                                <input id="u-range-10" type="text">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <!-- calendar js-->
    <script src="{{ asset('assets/js/range-slider/ion.rangeSlider.min.js') }}"></script>
    <script src="{{ asset('assets/js/range-slider/rangeslider-script.js') }}"></script>
@endsection
