@extends('layouts.master')

@section('title', 'Knob Chart')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Knob Chart</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Charts</li>
                <li class="breadcrumb-item f-w-400 active">Knob Chart</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-6 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Clock</h4>
                    </div>
                    <div class="card-body">
                        <div class="knob-block text-center knob-chart">
                            <div class="chart-clock-main">
                                <div class="clock-large">
                                    <input class="knob hour" data-min="0" data-max="24" data-bgcolor="#eeeeee"
                                        data-fgcolor="#7A70BA" data-displayinput="false" data-width="300" data-height="300"
                                        data-thickness=".2">
                                </div>
                                <div class="clock-medium">
                                    <input class="knob minute" data-min="0" data-max="60" data-bgcolor="#eeeeee"
                                        data-fgcolor="#dc3545" data-displayinput="false" data-width="200" data-height="200"
                                        data-thickness=".20">
                                </div>
                                <div class="clock-small">
                                    <input class="knob second" data-min="0" data-max="60" data-bgcolor="#eeeeee"
                                        data-fgcolor="#51bb25" data-displayinput="false" data-width="100" data-height="100"
                                        data-thickness=".2">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Tron</h4>
                    </div>
                    <div class="card-body">
                        <div class="knob-block text-center">
                            <input class="knob" data-width="295" data-height="295" data-angleoffset="180"
                                data-fgcolor="#7A70BA" data-skin="tron" data-thickness=".1" value="35">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Angle Offset</h4>
                    </div>
                    <div class="card-body">
                        <div class="knob-block text-center">
                            <input class="knob" data-width="200" data-thickness=".1" data-angleoffset="90"
                                data-fgcolor="#7A70BA" data-linecap="round" value="35">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Disable Display Input</h4>
                    </div>
                    <div class="card-body">
                        <div class="knob-block text-center knob-input-disable">
                            <input class="knob" data-width="200" data-thickness=".1" data-fgcolor="#7A70BA"
                                data-displayinput="false" value="35">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Cursor Mode</h4>
                    </div>
                    <div class="card-body">
                        <div class="knob-block text-center">
                            <input class="knob" data-width="200" data-cursor="true" data-fgcolor="#7A70BA"
                                data-thickness=".1" value="29">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Display Previous Value</h4>
                    </div>
                    <div class="card-body">
                        <div class="knob-block text-center">
                            <input class="knob" data-width="200" data-thickness=".1" data-fgcolor="#7A70BA"
                                data-min="-100" data-displayprevious="true" value="44">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Angle Offset & Arc</h4>
                    </div>
                    <div class="card-body">
                        <div class="knob-block text-center">
                            <input class="knob" data-angleoffset="-125" data-anglearc="250" data-fgcolor="#7A70BA"
                                data-thickness=".1" data-rotation="anticlockwise" value="35">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4>4-digit, step 0.1</h4>
                    </div>
                    <div class="card-body">
                        <div class="knob-block text-center">
                            <input class="knob" data-min="-10000" data-thickness=".1" data-fgcolor="#7A70BA"
                                data-displayprevious="true" data-max="10000" data-step=".1" value="0">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <script src="{{ asset('assets/js/chart/knob/knob.min.js') }}"></script>
    <script src="{{ asset('assets/js/chart/knob/knob-chart.js') }}"></script>
@endsection
