@extends('layouts.master')

@section('title', 'Chartist Chart')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/chartist.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Chartist Chart</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Charts</li>
                <li class="breadcrumb-item f-w-400 active">Chartist Chart</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-6 col-md-12 col-sm-12 box-col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Advanced SMIL Animations</h4>
                    </div>
                    <div class="card-body">
                        <div class="ct-6 flot-chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-md-12 col-sm-12 box-col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>SVG Path animation</h4>
                    </div>
                    <div class="card-body">
                        <div class="ct-7 flot-chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-md-12 col-sm-12 box-col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Animating a Donut with Svg.animate</h4>
                    </div>
                    <div class="card-body">
                        <div class="ct-8 flot-chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-md-12 col-sm-12 box-col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Bi-polar Line chart with area only</h4>
                    </div>
                    <div class="card-body">
                        <div class="ct-5 flot-chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-md-12 col-sm-12 box-col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Line chart with area</h4>
                    </div>
                    <div class="card-body">
                        <div class="ct-4 flot-chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-md-12 col-sm-12 box-col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Bi-polar bar chart</h4>
                    </div>
                    <div class="card-body">
                        <div class="ct-9 flot-chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-md-12 col-sm-12 box-col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Stacked bar chart</h4>
                    </div>
                    <div class="card-body">
                        <div class="ct-10 flot-chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-md-12 col-sm-12 box-col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Horizontal bar chart</h4>
                    </div>
                    <div class="card-body">
                        <div class="ct-11 flot-chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-md-12 col-sm-12 box-col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Extreme responsive configuration</h4>
                    </div>
                    <div class="card-body">
                        <div class="ct-12 flot-chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-md-12 col-sm-12 box-col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Simple line chart</h4>
                    </div>
                    <div class="card-body">
                        <div class="ct-1 flot-chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-md-12 col-sm-12 box-col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Holes in data</h4>
                    </div>
                    <div class="card-body">
                        <div class="ct-2 flot-chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-md-12 col-sm-12 box-col-8">
                <div class="card">
                    <div class="card-header">
                        <h4>Filled holes in data</h4>
                    </div>
                    <div class="card-body">
                        <div class="ct-3 flot-chart-container"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <script src="{{ asset('assets/js/chart/chartist/chartist.js') }}"></script>
    <script src="{{ asset('assets/js/chart/chartist/chartist-plugin-tooltip.js') }}"></script>
    <script src="{{ asset('assets/js/chart/chartist/chartist-custom.js') }}"></script>
@endsection
