<?php $__env->startSection('title', 'Admin Dashboard'); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/animate.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/datatables.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/date-range-picker/flatpickr.min.css')); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/date-picker.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/owlcarousel.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/rating.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/vector-map.css')); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/range-slider.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/fullcalender.css')); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/chartist.css')); ?>">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/litepicker/dist/css/litepicker.css" />

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/vector-map.css')); ?>">



    <style>
        /* Force readable toast color */
        #toast-container>.toast {
            color: #000 !important;
            background-color: #fff !important;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-left: 4px solid #28a745;
            /* green stripe for success */
        }

        #toast-container>.toast-error {
            border-left-color: #dc3545;
        }

        #toast-container>.toast-info {
            border-left-color: #17a2b8;
        }

        #toast-container>.toast-warning {
            border-left-color: #ffc107;
        }

        #shifts-overview {
            position: relative;
        }

        #claimsLoader {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        #toast-container>.toast {
            color: #000 !important;
            background: #fff !important;
        }

        .fc-tooltip {
            background: #fff;
            padding: 8px;
            border: 1px solid #ccc;
            font-size: 13px;
            position: absolute;
            top: 30px;
            left: 0;
            z-index: 100;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            display: none;
        }

        .fc-event:hover .fc-tooltip {
            display: block;
        }

        .bg-gradient-info { background: linear-gradient(45deg, #17a2b8, #117a8b) !important; }
        .bg-gradient-success { background: linear-gradient(45deg, #28a745, #1e7e34) !important; }
        .bg-gradient-danger { background: linear-gradient(45deg, #dc3545, #bd2130) !important; }
        .bg-gradient-primary { background: linear-gradient(45deg, #007bff, #0056b3) !important; }

/* Make sure event titles are wrapped and visible in timeGrid views */

/* Apply custom styles only when NOT in month view */
.fc-timeGridWeek .fc-task-box,
.fc-timeGridDay .fc-task-box {
  display: flex;
  flex-direction: column;
  padding: 4px 6px;
  width: 100%;
  overflow: hidden;
  box-sizing: border-box;
}

.fc-task-text-box {
  line-height: 1.2;
  overflow: hidden;
  text-overflow: ellipsis;
  width: 100%;
  white-space: normal;
}

.fc-task-text {
  color: #fff !important;
  font-size: 0.85rem;
  font-weight: 500;
  display: block;
  word-break: break-word;
  overflow-wrap: anywhere;
}




    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="<?php echo e(route('admin.dashboard')); ?>"><img class="img-fluid for-light"
                    src="<?php echo e(asset('assets/images/logo/logo.png')); ?>" alt="" /><img class="img-fluid for-dark"
                    src="<?php echo e(asset('assets/images/logo/logo_light.png')); ?>" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Admin dashboard</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Dashboard</li>
                <li class="breadcrumb-item f-w-400 active">Admin dashboard</li>
            </ol>
        </nav>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
    <!-- Container-fluid starts-->
    <div class="container-fluid default-dashboard">
        <div class="row widget-grid ">
            <div class="row widget-grid d-flex align-items-stretch">
                <div class="col-xl-4 col-md-6 proorder-xl-1 proorder-md-1">
                    <div class="card profile-greeting p-0 h-100">
                        <div class="card-body d-flex align-items-center justify-content-center text-center">
                            <div class="img-overlay">
                                <?php
                                    use Carbon\Carbon;

                                    $hour = Carbon::now()->hour;
                                    $greeting = 'Good day';
                                    $emoji = '👋';

                                    if ($hour >= 5 && $hour < 12) {
                                        $greeting = 'Good morning';
                                        $emoji = '🌞';
                                    } elseif ($hour >= 12 && $hour < 17) {
                                        $greeting = 'Good afternoon';
                                        $emoji = '☀️';
                                    } elseif ($hour >= 17 && $hour < 21) {
                                        $greeting = 'Good evening';
                                        $emoji = '🌇';
                                    } else {
                                        $greeting = 'Good night';
                                        $emoji = '🌙';
                                    }
                                ?>

                                <h1 class="mb-3"><?php echo e($emoji); ?> <?php echo e($greeting); ?>,<br> <?php echo e(Auth::user()->first_name); ?>

                                    <?php echo e(Auth::user()->last_name); ?>

                                </h1>
                                <p class="welcome-msg text-muted">
                                    Welcome to the Insurance CRM System — your trusted workspace for managing clients,
                                    policies, and claims.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>



                <!-- Customer Growth-->
                <div class="col-xl-3 col-md-6 proorder-xl-2 proorder-md-2">
                    <div class="card h-100">
                        <div class="card-header card-no-border pb-0">
                            <div class="header-top d-flex justify-content-between align-items-center">
                                <h4>
                                    Customer Growth <span id="growthPeriodLabel" class="text-muted small">(Monthly)</span>
                                </h4>
                                <div class="dropdown">
                                    <button class="btn btn-sm dropdown-toggle" id="growthDropdown" type="button"
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                        Filter
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-end p-2" aria-labelledby="growthDropdown">
                                        <a class="dropdown-item growth-filter" href="#" data-period="daily">Daily</a>
                                        <a class="dropdown-item growth-filter" href="#" data-period="weekly">Weekly</a>
                                        <a class="dropdown-item growth-filter" href="#" data-period="monthly">Monthly</a>
                                        <a class="dropdown-item growth-filter" href="#" data-period="yearly">Yearly</a>
                                        <div class="dropdown-divider"></div>
                                        <div class="text-muted small">Custom</div>
                                        <input type="text" id="growthDateRange" class="form-control form-control-sm mb-2"
                                            placeholder="Select range" readonly>
                                        <button class="btn btn-sm btn-primary w-100" id="applyGrowthCustom">Apply</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body pb-0 opening-box">
                            <div class="d-flex align-items-center gap-2">
                                <h2><i class="fa fa-users"></i> <span id="customerTotal">0</span></h2>
                                <div class="d-flex ms-auto align-items-center">
                                    <p class="mb-0 up-arrow"><i id="customerArrow" class="fa fa-arrow-up text-success"></i>
                                    </p>
                                    <span id="customerPercentage" class="f-w-500 font-success ms-1">+0%</span>
                                </div>
                            </div>
                            <div id="growthchart" class="position-relative" style="height: 180px;"></div>
                        </div>
                    </div>
                </div>


                <!-- Customer Growth End-->

                <!-- Claims-->

                <div class="col-xl-5 col-md-5 proorder-xl-3 proorder-md-3">
                    <div class="card shifts-char-box h-100">
                        <div class="card-header card-no-border pb-0">
                            <div class="header-top">
                                <h4>Claims by Status <span id="claimsPeriodLabel" class="text-muted small">(Monthly)</span>
                                </h4>

                                <!-- Date Range Picker Dropdown -->
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-outline-dark dropdown-toggle" type="button"
                                        data-bs-toggle="dropdown">
                                        <i class="fa fa-calendar"></i> <span id="selectedRange">Date Pick</span>
                                    </button>
                                    <div class="dropdown-menu p-3" style="min-width: 250px;">
                                        <input type="text" id="dateRangePicker" class="form-control" readonly
                                            style="cursor:pointer;" />
                                        <button class="btn btn-primary btn-sm w-100 mt-2" id="applyDateRange">Apply</button>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center gap-3">
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-primary dropdown-toggle"
                                            data-bs-toggle="dropdown">
                                            Filter
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li><a class="dropdown-item status-filter" data-period="weekly"
                                                    href="#">Weekly</a></li>
                                            <li><a class="dropdown-item status-filter" data-period="monthly"
                                                    href="#">Monthly</a></li>
                                            <li><a class="dropdown-item status-filter" data-period="yearly"
                                                    href="#">Yearly</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">
                            <div class="row align-items-start">
                                <!-- Chart Area -->
                                <div class="col-md-6">
                                    <div id="shifts-overview" style="min-height:250px;"></div>
                                </div>

                                <!-- Status List Area -->
                                <div class="col-md-6">
                                    <div id="claimsStatusList" class="ms-md-4 mt-4 mt-md-0"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
            <!-- Claims End-->





            <div class="row g-3">
                <!-- Total Customers -->
                <div class="col-xl-3 col-sm-6">
                    <div class="card position-relative">
                        <div class="card-header card-no-border pb-0 d-flex justify-content-between align-items-center">
                            <h4>Total Customers</h4>
                            <div class="dropdown">
                                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                                    <span id="status-label">All</span>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a href="#" class="dropdown-item customer-status-filter" data-status="all">All</a>
                                    </li>
                                    <li><a href="#" class="dropdown-item customer-status-filter"
                                            data-status="active">Active</a></li>
                                    <li><a href="#" class="dropdown-item customer-status-filter"
                                            data-status="inactive">Inactive</a></li>
                                    <li><a href="#" class="dropdown-item customer-status-filter"
                                            data-status="blacklisted">Blacklisted</a></li>
                                </ul>
                            </div>
                        </div>

                        <div class="card-body pb-0 total-sells position-relative">
                            <!-- Loader Spinner -->
                            <div id="customer-loader"
                                class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center bg-white bg-opacity-75 d-none"
                                style="z-index:10;">
                                <div class="spinner-border text-primary" role="status"></div>
                            </div>

                            <div class="d-flex align-items-center gap-3">
                                <div class="flex-shrink-0">
                                    <img src="<?php echo e(asset('assets/images/dashboard-3/icon/customers.png')); ?>" alt="icon">
                                </div>
                                <div class="flex-grow-1">
                                    <h2 id="customer-total">0</h2>
                                    <p class="text-truncate">As of <?php echo e(now()->format('F Y')); ?></p>
                                </div>
                            </div>

                            <div id="total-customers-chart" style="height: 100px;"></div>

                            <button id="export-customers" class="btn btn-sm btn-outline-primary w-100 mt-3">
                                Export
                            </button>
                        </div>
                    </div>
                </div>


                <!-- Active Policies -->
                <div class="col-xl-3 col-sm-6">
                    <div class="card position-relative">
                        <div class="card-header card-no-border pb-0 d-flex justify-content-between align-items-center">
                            <h4>Policies</h4>
                            <div class="dropdown">
                                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                                    <span id="policy-status-label">All</span>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item policy-status-filter" href="#" data-status="all">All</a>
                                    </li>
                                    <li><a class="dropdown-item policy-status-filter" href="#"
                                            data-status="active">Active</a></li>
                                    <li><a class="dropdown-item policy-status-filter" href="#"
                                            data-status="inactive">Inactive</a></li>
                                    <li><a class="dropdown-item policy-status-filter" href="#"
                                            data-status="cancelled">Cancelled</a></li>
                                    <li><a class="dropdown-item policy-status-filter" href="#"
                                            data-status="expired">Expired</a></li>
                                </ul>
                            </div>
                        </div>

                        <div class="card-body pb-0 total-sells-2 position-relative" style="min-height: 150px;">
                            <!-- Loader -->


                            <div id="policy-loader"
                                class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center bg-white bg-opacity-75 d-none"
                                style="z-index:10;">
                                <div class="spinner-border text-primary" role="status"></div>
                            </div>

                            <div class="d-flex align-items-center gap-3">
                                <div class="flex-shrink-0">
                                    <img src="<?php echo e(asset('assets/images/dashboard-3/icon/policy.png')); ?>" alt="icon">
                                </div>
                                <div class="flex-grow-1">
                                    <h2 id="policy-total">0</h2>
                                    <p class="text-truncate">Current active count</p>
                                </div>
                            </div>

                            <div id="active-policies-chart" style="height: 100px;"></div>

                            <button id="export-policies" class="btn btn-sm btn-outline-primary w-100 mt-3">
                                Export
                            </button>
                        </div>
                    </div>
                </div>





                <div class="col-xl-3 col-sm-6">
                    <!-- Premium Collected Card -->
                    <div class="card position-relative">
                        <div id="premium-loader"
                            class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center bg-white bg-opacity-75 d-none"
                            style="z-index: 10;">
                            <div class="spinner-border text-primary" role="status"></div>
                        </div>

                        <div class="card-header card-no-border pb-0 d-flex justify-content-between align-items-center">
                            <h4>Premium Collected</h4>
                            <div class="dropdown">
                                <button class="btn btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                    <span id="premium-filter-label">All</span>
                                </button>
                                <ul class="dropdown-menu p-2" style="min-width: 220px;">
                                    <li><a class="dropdown-item premium-filter" data-range="all" href="#">All</a></li>
                                    <li><a class="dropdown-item premium-filter" data-range="daily" href="#">Daily</a></li>
                                    <li><a class="dropdown-item premium-filter" data-range="weekly" href="#">Weekly</a></li>
                                    <li><a class="dropdown-item premium-filter" data-range="monthly" href="#">Monthly</a>
                                    </li>
                                    <li><a class="dropdown-item premium-filter" data-range="yearly" href="#">Yearly</a></li>
                                    <li class="dropdown-divider"></li>
                                    <li>
                                        <div class="text-muted small px-2 mb-1">Custom Range</div>
                                        <input type="text" id="customDateInline" class="form-control form-control-sm"
                                            placeholder="Select range">
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="card-body pb-0 total-sells-3">
                            <div class="d-flex align-items-center gap-3">
                                <div class="flex-shrink-0">
                                    <img src="<?php echo e(asset('assets/images/dashboard-3/icon/revenue.png')); ?>" alt="icon">
                                </div>
                                <div class="flex-grow-1">
                                    <h2><span id="premium-total">Birr 0</span></h2>
                                    <p class="text-truncate" id="premium-range-label">Since Jan 2025</p>
                                </div>
                            </div>
                            <div id="premium-chart"></div>
                        </div>
                    </div>

                </div>





                <!-- Unpaid Invoices -->
                <div class="col-xl-3 col-sm-6">
                    <div class="card position-relative">
                        <!-- Loader Overlay -->
                        <div id="invoice-loader"
                            class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center bg-white bg-opacity-75 d-none"
                            style="z-index: 10;">
                            <div class="spinner-border text-primary" role="status"></div>
                        </div>

                        <!-- Header with Dropdown Filter -->
                        <div class="card-header card-no-border pb-0 d-flex justify-content-between align-items-center">
                            <h4>Unpaid Invoices</h4>
                            <div class="dropdown">
                                <button class="btn btn-sm dropdown-toggle" type="button" id="invoiceFilterDropdown"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                    <span id="invoice-filter-label">All</span>
                                </button>
                                <ul class="dropdown-menu p-2" aria-labelledby="invoiceFilterDropdown"
                                    style="min-width: 220px;">
                                    <li><a class="dropdown-item invoice-filter" data-range="all" href="#">All</a></li>
                                    <li><a class="dropdown-item invoice-filter" data-range="daily" href="#">Daily</a></li>
                                    <li><a class="dropdown-item invoice-filter" data-range="weekly" href="#">Weekly</a></li>
                                    <li><a class="dropdown-item invoice-filter" data-range="monthly" href="#">Monthly</a>
                                    </li>
                                    <li><a class="dropdown-item invoice-filter" data-range="yearly" href="#">Yearly</a></li>
                                    <li>
                                        <hr class="dropdown-divider">
                                    </li>
                                    <li>
                                        <div class="text-muted small px-2 mb-1">Custom Range</div>
                                        <input type="text" id="invoiceCustomDateRange" class="form-control form-control-sm"
                                            placeholder="Select custom range" autocomplete="off" />
                                    </li>
                                </ul>
                            </div>


                        </div>

                        <!-- Body Content -->
                        <div class="card-body pb-0 total-sells-4">
                            <div class="d-flex align-items-center gap-3">
                                <div class="flex-shrink-0">
                                    <img src="<?php echo e(asset('assets/images/dashboard-3/icon/invoice.png')); ?>" alt="icon">
                                </div>

                                <div class="flex-grow-1">
                                    <h2><span id="invoice-total">0</span></h2>
                                    <p class="text-truncate mb-0" id="invoice-subtext">Pending collections</p>

                                </div>
                            </div>
                            <div id="invoice-chart" style="min-height: 90px;"></div>
                        </div>
                    </div>
                </div>


            </div>

            <div class="col-xxl-7 col-xl-100 box-col-12 proorder-xl-8 proorder-md-9">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top">
                            <h4>
                                Sales Statistic
                                <small class="text-muted" id="sales-stat-label">(Yearly)</small>
                            </h4>
                            <div class="dropdown icon-dropdown">
                                <button class="btn dropdown-toggle" id="sales-statistics-filter" type="button"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="icon-more-alt"></i>
                                </button>
                                <div class="dropdown-menu dropdown-menu-end">
                                    <a class="dropdown-item sales-stat-filter" data-range="daily" href="#">Daily</a>
                                    <a class="dropdown-item sales-stat-filter" data-range="weekly" href="#">Weekly</a>
                                    <a class="dropdown-item sales-stat-filter" data-range="monthly" href="#">Monthly</a>
                                    <a class="dropdown-item sales-stat-filter" data-range="yearly" href="#">Yearly</a>
                                    <div class="dropdown-divider"></div>
                                    <div class="px-3 py-2">
                                        <label class="form-label small">Custom Range</label>
                                        <input type="text" id="salesCustomDate" class="form-control form-control-sm"
                                            placeholder="YYYY-MM-DD to YYYY-MM-DD">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body sale-statistic">
                        <div class="row">
                            <div class="col-4 statistic-icon">
                                <div class="light-card balance-card widget-hover">
                                    <div class="icon-box">
                                        <img src="<?php echo e(asset('assets/images/dashboard/icon/customers.png')); ?>" alt="">
                                    </div>
                                    <div>
                                        <span class="f-w-500 f-light">Total Premium</span>
                                        <h5 class="mt-1 mb-0" id="total-premium">Birr 0</h5>
                                    </div>
                                    <div class="ms-auto text-end">
                                        <!-- Premium -->
                                        <span class="f-w-600" id="premium-change">
                                            <i class="fa fa-arrow-up text-success me-1 d-none" id="premium-up"></i>
                                            <i class="fa fa-arrow-down text-danger me-1 d-none" id="premium-down"></i>
                                            <span id="premium-percent">0%</span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4 statistic-icon">
                                <div class="light-card balance-card widget-hover">
                                    <div class="icon-box">
                                        <img src="<?php echo e(asset('assets/images/dashboard/icon/revenue.png')); ?>" alt="">
                                    </div>
                                    <div>
                                        <span class="f-w-500 f-light">New Leads</span>
                                        <h5 class="mt-1 mb-0" id="total-leads">0</h5>
                                    </div>
                                    <div class="ms-auto text-end">
                                        <!-- Leads -->
                                        <span class="f-w-600" id="leads-change">
                                            <i class="fa fa-arrow-up text-success me-1 d-none" id="leads-up"></i>
                                            <i class="fa fa-arrow-down text-danger me-1 d-none" id="leads-down"></i>
                                            <span id="leads-percent">0%</span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4 statistic-icon">
                                <div class="light-card balance-card widget-hover">
                                    <div class="icon-box">
                                        <img src="<?php echo e(asset('assets/images/dashboard/icon/profit.png')); ?>" alt="">
                                    </div>
                                    <div>
                                        <span class="f-w-500 f-light">Policies Sold</span>
                                        <h5 class="mt-1 mb-0" id="policies-sold">0</h5>
                                    </div>
                                    <div class="ms-auto text-end">
                                        <!-- Policies -->
                                        <span class="f-w-600" id="policies-change">
                                            <i class="fa fa-arrow-up text-success me-1 d-none" id="policies-up"></i>
                                            <i class="fa fa-arrow-down text-danger me-1 d-none" id="policies-down"></i>
                                            <span id="policies-percent">0%</span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="chart-dash-2-line-loader" class="text-center my-3 d-none">
                            <div class="spinner-border text-primary"></div>
                        </div>
                        <div id="chart-dash-2-line"></div>
                    </div>
                </div>
            </div>



            <div class="col-xl-5 col-xl-100 col-md-6 proorder-md-12">
    <div class="card">
        <div class="card-header card-no-border pb-0">
            <div class="header-top d-flex justify-content-between align-items-center">
                <h4 class="mb-0">Upcoming Appointments</h4>
                <div class="d-flex align-items-center gap-2">

                                    <!-- Fullscreen Button -->
                    <button type="button" class="btn btn-outline-secondary p-1" data-bs-toggle="modal"
                    data-bs-target="#openAppointmentModal">
                    <i class="icofont icofont-maximize"></i>
                    </button>
                    <!-- Filter Dropdown -->
                    <div class="dropdown icon-dropdown me-2">
                        <button class="btn dropdown-toggle" id="calendarFilter" type="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="icon-more-alt"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="calendarFilter">
                            <a class="dropdown-item calendar-range" data-range="daily" href="#">Daily</a>
                            <a class="dropdown-item calendar-range" data-range="weekly" href="#">Weekly</a>
                            <a class="dropdown-item calendar-range" data-range="monthly" href="#">Monthly</a>
                            <a class="dropdown-item calendar-range" data-range="yearly" href="#">Yearly</a>
                        </div>
                    </div>


                </div>
            </div>
        </div>

        <div class="card-body overflow-auto theme-scrollbar">
            <div class="timeline-calendar custom-scrollbar position-relative">
            <div id="calendar-card-loader" class="text-center my-3 d-none">
  <div class="spinner-border text-primary"></div>
</div>
                <div class="custom-calendar" id="calendar"></div>
            </div>
        </div>
    </div>
</div>


<div class="row">
<div class="col-12">
  <div class="card">
    <div class="card-header">
      <h4>Customers by Map</h4>
      <span>The map shows customer distribution by Ethiopian Region.</span>
    </div>
    <div class="card-body">
      <div class="d-flex" style="gap: 20px;">
        <!-- Map container -->
        <div id="ethiopia-map" style="width: 75%; height: 500px; position: relative;"></div>

        <!-- Legend container -->
        <div id="map-legend" style="width: 25%; font-family: Arial, sans-serif;"></div>
      </div>
    </div>
  </div>
</div>






        </div>
    </div>
    <!-- Container-fluid Ends-->

    <!-- Claims Drilldown Modal -->
    <div class="modal fade" id="claimsDrilldownModal" tabindex="-1" aria-labelledby="claimsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="claimsModalLabel">Claims - <span id="drillLabel"></span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="claimsDrilldownModalBody">
                    <div class="text-center py-4">
                        <div class="spinner-border text-primary"></div>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <div id="claimsPagination"></div>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>


    <!-- Policy Drilldown Modal -->

    <div class="modal fade" id="policyDrilldownModal" tabindex="-1" aria-labelledby="policyDrilldownLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Policies - <span id="policyDrilldownStatus">All</span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <!-- Search Input -->
                    <div class="mb-3 d-flex justify-content-between">
                        <input type="text" class="form-control w-50" id="policySearchInput"
                            placeholder="Search by policy number or name...">
                    </div>

                    <!-- Loader -->
                    <div id="policy-drilldown-loader" class="d-flex justify-content-center py-4">
                        <div class="spinner-border text-secondary" role="status"></div>
                    </div>

                    <!-- Table -->
                    <div class="table-responsive d-none" id="policyDrilldownTableContainer">
                        <table class="table table-hover align-middle mb-0 table-inverse table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Policy Number</th>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Start</th>
                                    <th>End</th>
                                    <th>Premium</th>
                                </tr>
                            </thead>
                            <tbody id="policyDrilldownTableBody"></tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <nav class="mt-3 d-none" id="policyDrilldownPagination">
                        <ul class="pagination justify-content-center" id="policyPaginationList"></ul>
                    </nav>

                </div>
            </div>
        </div>
    </div>


    <!-- Policy Details Modal -->
    <div class="modal fade" id="policyDetailModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content position-relative">

                <!-- Loader Overlay -->
                <div id="policy-modal-loader"
                    class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center bg-white bg-opacity-75 d-none"
                    style="z-index: 1050;">
                    <div class="spinner-border text-primary" role="status"></div>
                </div>

                <div class="modal-header bg-light">
                    <h5 class="modal-title fw-bold">Policy Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <!-- Tabs -->
                    <ul class="nav nav-tabs nav-tabs-bordered mb-3" id="policyTabs" role="tablist">
                        <li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#customer">Customer</a>
                        </li>
                        <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#policy">Policy</a></li>
                        <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#claims">Claims</a></li>
                    </ul>

                    <!-- Tab Content -->
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="customer">
                            <div class="text-center text-muted">Loading...</div>
                        </div>
                        <div class="tab-pane fade" id="policy">
                            <div class="text-center text-muted">Loading...</div>
                        </div>
                        <div class="tab-pane fade" id="claims">
                            <div class="text-center text-muted">Loading...</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>







<!-- Appointment Modal -->

<div class="modal fade" id="openAppointmentModal" tabindex="-1" aria-labelledby="appointmentModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered" style="max-width: 850px;">
    <div class="modal-content shadow rounded-4" style="height: 80vh; display: flex; flex-direction: column;">

      <!-- Header -->
      <div class="modal-header bg-primary text-white rounded-top-4">
        <h5 class="modal-title" id="appointmentModalLabel"><i class="bi bi-calendar3-event"></i> Appointment Calendar</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <!-- Body -->
      <div class="modal-body p-0 position-relative flex-grow-1 overflow-hidden">
        <!-- Spinner Loader -->
        <div id="modal-calendar-loader" class="position-absolute top-50 start-50 translate-middle d-none" style="z-index: 1055;">
          <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span>
          </div>
        </div>

        <!-- Calendar -->
        <div id="calendarModal" class="w-100 h-100 p-2 bg-light rounded-bottom-3"></div>
      </div>

      <!-- Footer -->
      <div class="modal-footer bg-light rounded-bottom-4">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>


<!-- Event Details Modal -->
<div class="modal fade" id="eventDetailsModal" tabindex="-1" aria-labelledby="eventDetailsModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="eventDetailsModalLabel">Appointment Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        Loading...
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/chart/apex-chart/apex-chart.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/apex-chart/stock-prices.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/apex-chart/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/notify/bootstrap-notify.min.js')); ?>"></script>
    <!-- calendar js-->
    <script src="<?php echo e(asset('assets/js/dashboard/default.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/notify/index.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/datatable.custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/datatable.custom1.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datepicker/date-range-picker/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datepicker/date-range-picker/datepicker-range-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/handlebars.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/typeahead.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/typeahead.custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead-search/handlebars.js')); ?>"></script>




    <!-- calendar js-->
    <script src="<?php echo e(asset('assets/js/calendar/fullcalender.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/calendar/custom-calendar.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/chart/morris-chart/raphael.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/morris-chart/morris.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/morris-chart/prettify.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/apex-chart/apex-chart.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/apex-chart/stock-prices.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/apex-chart/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/echart/pie-chart/facePrint.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/echart/pie-chart/testHelper.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/echart/pie-chart/custom-transition-texture.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/echart/data/symbols.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/slick/slick-theme.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/jquery-jvectormap-2.0.2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-africa-mill.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-us-aea-en.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-uk-mill-en.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-au-mill.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-chicago-mill-en.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-in-mill.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map/jquery-jvectormap-asia-mill.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map-vector.js')); ?>"></script>


    <script src="<?php echo e(asset('assets/js/datepicker/date-picker/datepicker.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datepicker/date-picker/datepicker.en.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datepicker/date-picker/datepicker.custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/rating/jquery.barrating.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/rating/rating-script.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/owlcarousel/owl.carousel.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vector-map/map-vector.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/countdown.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/dashboard/dashboard_3.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/dashboard/dashboard_2.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/ecommerce.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/handlebars.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/typeahead.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/typeahead.custom.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/typeahead-search/typeahead-custom.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/height-equal.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/animation/wow/wow.min.js')); ?>"></script>

    <script src="https://cdn.jsdelivr.net/npm/litepicker/dist/litepicker.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

    <script src="https://cdn.jsdelivr.net/npm/moment/min/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>




    <!-- Chart -->

    <script src="<?php echo e(asset('assets/js/chart/chartist/chartist.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/chartist/chartist-plugin-tooltip.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/chartist/chartist-custom.js')); ?>"></script>




    <!-- Chart End-->

    <script>
        new WOW().init();
    </script>

    <script>

        let growthPicker = new Litepicker({
            element: document.getElementById('growthDateRange'),
            singleMode: false,
            format: 'YYYY-MM-DD',
            numberOfMonths: 2,
            numberOfColumns: 2
        });

        (function () {
            let growthchart = null;

            // ✅ Setup Toastr


            // ✅ Loader
            function showLoader() {
                $('#growthchart').addClass('position-relative').append(`
                                            <div id="growthLoader" class="position-absolute top-50 start-50 translate-middle text-center">
                                                <div class="spinner-border text-primary" role="status" style="width: 1.5rem; height: 1.5rem;"></div>
                                            </div>
                                        `);
            }

            function hideLoader() {
                $('#growthLoader').remove();
            }

            // ✅ Animated Counter
            function animateCounter($el, target, duration = 800, prefix = '', suffix = '') {
                const start = parseFloat($el.text().replace(/,/g, '')) || 0;
                const stepCount = Math.ceil(duration / 16); // ~60fps
                const stepSize = (target - start) / stepCount;
                let current = start;
                let step = 0;

                const counter = setInterval(() => {
                    step++;
                    current += stepSize;
                    if (step >= stepCount) {
                        current = target;
                        clearInterval(counter);
                    }
                    $el.text(prefix + Math.round(current).toLocaleString() + suffix);
                }, 16);
            }

            // ✅ Load Data
            function loadGrowth(period = 'monthly', start = null, end = null) {

                $('#growthPeriodLabel').text(`(${period.charAt(0).toUpperCase() + period.slice(1)})`);

                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "positionClass": "toast-bottom-right",
                    "timeOut": "3000",
                    "extendedTimeOut": "1000",
                    "showMethod": "fadeIn",
                    "hideMethod": "fadeOut"
                };
                showLoader();

                $.ajax({
                    url: `dashboard/customer-growth`,
                    type: 'GET',
                    data: { period, start, end },
                    success: function (data) {
                        const options = {
                            series: [{ name: 'Growth', data: data.series }],
                            chart: {
                                height: 150,
                                type: 'line',
                                stacked: true,
                                toolbar: { show: false },
                                dropShadow: {
                                    enabled: true,
                                    top: 5,
                                    left: 0,
                                    blur: 4,
                                    color: '#7A70BA',
                                    opacity: 0.22
                                },
                            },
                            grid: {
                                show: true,
                                borderColor: '#000000',
                                xaxis: { lines: { show: true } },
                                yaxis: { lines: { show: false } },
                            },
                            colors: ["#5527FF"],
                            stroke: { width: 3, curve: 'smooth' },
                            xaxis: {
                                categories: data.labels,
                                type: 'category',
                                tickAmount: 10,
                                labels: {
                                    style: {
                                        fontFamily: 'Outfit, sans-serif',
                                        fontWeight: 500,
                                        colors: '#8D8D8D',
                                    }
                                },
                                axisTicks: { show: false },
                                axisBorder: { show: false },
                                tooltip: { enabled: false }
                            },
                            fill: {
                                type: 'gradient',
                                gradient: {
                                    shade: 'dark',
                                    gradientToColors: ['#5527FF'],
                                    shadeIntensity: 1,
                                    type: 'horizontal',
                                    opacityFrom: 1,
                                    opacityTo: 1,
                                    colorStops: [
                                        { offset: 0, color: "#7A70BA", opacity: 1 },
                                        { offset: 100, color: "#48A3D7", opacity: 1 }
                                    ]
                                },
                            },
                            yaxis: {
                                min: 0,
                                max: Math.max(...data.series) + 10,
                                labels: { show: false }
                            }
                        };

                        if (growthchart) {
                            growthchart.updateOptions(options);
                        } else {
                            growthchart = new ApexCharts(document.querySelector("#growthchart"), options);
                            growthchart.render();
                        }

                        // ✅ Animate total count
                        animateCounter($('#customerTotal'), data.total);

                        // ✅ Animate percentage and handle color/arrow
                        const $percentage = $('#customerPercentage');
                        const $arrow = $('#customerArrow');
                        const percentVal = parseFloat(data.percentage || 0);

                        animateCounter($percentage, percentVal, 500, percentVal > 0 ? '+' : '', '%');

                        $percentage
                            .removeClass('font-success font-danger text-muted')
                            .addClass(percentVal > 0 ? 'font-success' : (percentVal < 0 ? 'font-danger' : 'text-muted'));

                        $arrow
                            .removeClass('fa-arrow-up fa-arrow-down text-success text-danger text-muted')
                            .addClass(
                                percentVal > 0 ? 'fa-arrow-up text-success' :
                                    percentVal < 0 ? 'fa-arrow-down text-danger' : 'text-muted'
                            );

                        toastr.success(`Customer growth data (${period}) loaded successfully`);
                    },
                    error: function () {
                        toastr.error("Failed to load customer growth data.");
                    },
                    complete: function () {
                        hideLoader();
                    }
                });
            }

            $('#applyGrowthCustom').on('click', function () {
                const range = $('#growthDateRange').val();
                if (!range.includes(' - ')) {
                    toastr.warning("Please select a valid date range.");
                    return;
                }
                const [start, end] = range.split(' - ');
                loadGrowth('custom', start.trim(), end.trim());
            });

            // ✅ Event Bindings
            $(document).ready(function () {
                loadGrowth('monthly');

                $('.growth-filter').on('click', function (e) {
                    e.preventDefault();
                    const period = $(this).data('period');
                    loadGrowth(period);
                });
            });
        })();
    </script>

    <script>




        (function () {
            let chart = null;

            // Toastr settings

            // Show loader inside chart
            function showLoader() {
                $('#shifts-overview').append(
                    '<div id="claimsLoader" class="text-center py-4">' +
                    '<div class="spinner-border text-primary" role="status"></div></div>'
                );
            }

            // Hide loader
            function hideLoader() {
                $('#claimsLoader').remove();
            }

            // Load donut chart data by time period
            function loadClaims(period = 'monthly', start = null, end = null) {

                toastr.options = {
                    positionClass: "toast-bottom-right",
                    progressBar: true,
                    timeOut: "3000"
                };

                $('#claimsPeriodLabel').text(`(${period.charAt(0).toUpperCase() + period.slice(1)})`);
                showLoader();

                $.ajax({
                    url: 'dashboard/claims-status',
                    data: { period, start, end },
                    success(data) {
                        const options = {
                            labels: data.labels,
                            series: data.series,
                            chart: {
                                type: 'donut',
                                height: 250,
                                events: {
                                    dataPointSelection: function (event, chartContext, config) {
                                        const label = data.labels[config.dataPointIndex];
                                        const statusMap = {
                                            'Pending': 'pending',
                                            'Under Review': 'under_review',
                                            'Approved': 'approved',
                                            'Rejected': 'rejected',
                                            'Paid': 'paid',
                                            'Closed': 'closed'
                                        };
                                        const statusKey = statusMap[label];
                                        if (statusKey) loadClaimsByStatus(statusKey, label);
                                    }
                                }
                            },
                            dataLabels: { enabled: false },
                            legend: { show: false },
                            stroke: { width: 6 },
                            plotOptions: {
                                pie: {
                                    expandOnClick: false,
                                    donut: {
                                        size: "83%",
                                        labels: {
                                            show: true,
                                            name: { offsetY: 4 },
                                            total: {
                                                show: true,
                                                fontSize: "20px",
                                                fontFamily: "Outfit, sans-serif",
                                                fontWeight: 600,
                                                label: data.total.toLocaleString(),
                                                formatter: () => "Total Claims"
                                            }
                                        }
                                    }
                                }
                            },
                            colors: ["#F4C430", "#7A70BA", "#48A3D7", "#DC3545", "#28A745", "#6C757D"]
                        };

                        if (chart) chart.updateOptions(options);
                        else {
                            chart = new ApexCharts(document.querySelector("#shifts-overview"), options);
                            chart.render();
                        }

                        // List of statuses and counts
                        const statusColors = ['warning', 'tertiary', 'primary', 'danger', 'success', 'secondary'];
                        let html = '';
                        data.labels.forEach((label, i) => {
                            html += `
                                            <div class="d-flex gap-2 mb-2">
                                              <div class="flex-shrink-0">
                                                <span class="bg-${statusColors[i]} rounded-circle d-inline-block" style="width:10px;height:10px;"></span>
                                              </div>
                                              <div class="flex-grow-1"><h6 class="mb-0">${label}</h6></div>
                                              <span>${data.series[i]}</span>
                                            </div>`;
                        });
                        $('#claimsStatusList').html(html);

                        toastr.success('Claims status loaded.');
                    },
                    error() {
                        toastr.error('Failed to load claims.');
                    },
                    complete() {
                        hideLoader();
                    }
                });
            }

            // Load detailed claims by status
            function loadClaimsByStatus(status, labelText, page = 1) {
                $('#claimsModalLabel').text(labelText);
                $('#claimsDrilldownModalBody').html(`
                                    <div class="text-center py-4">
                                      <div class="spinner-border text-primary"></div>
                                    </div>
                                  `);
                $('#claimsPagination').html('');
                const modal = new bootstrap.Modal(document.getElementById('claimsDrilldownModal'));
                modal.show();

                $.ajax({
                    url: 'dashboard/claims-by-status',
                    data: { status, page },
                    success(res) {
                        if (!res.data || res.data.length === 0) {
                            $('#claimsDrilldownModalBody').html(
                                `<div class="alert alert-info">No claims found for <strong>${labelText}</strong>.</div>`
                            );
                            return;
                        }

                        let html = `
                                      <div class="table-responsive">
                                        <table class="table table-sm  table-inverse table-striped table-bordered ">
                                          <thead class="table-light">
                                            <tr>
                                              <th>#</th>
                                              <th>Claim No</th>
                                              <th>Policy No</th>
                                              <th>Type</th>
                                              <th>Incident</th>
                                              <th>Requested</th>
                                            </tr>
                                          </thead>
                                          <tbody>`;

                        res.data.forEach((c, i) => {
                            html += `<tr>
                                          <td>${i + 1}</td>
                                          <td>${c.claim_number}</td>
                                          <td>${c.policy_number}</td>
                                          <td>${c.claim_type}</td>
                                          <td>${c.incident_date}</td>
                                          <td>${Number(c.claim_amount_requested).toLocaleString()} ETB</td>
                                        </tr>`;
                        });

                        html += `</tbody></table></div>`;
                        $('#claimsDrilldownModalBody').html(html);

                        // Add pagination controls
                        const p = res.pagination;
                        let paginationHtml = `<nav><ul class="pagination mb-0">`;
                        for (let i = 1; i <= p.last_page; i++) {
                            paginationHtml += `
                                          <li class="page-item ${i === p.current_page ? 'active' : ''}">
                                            <a class="page-link" href="#" data-page="${i}">${i}</a>
                                          </li>`;
                        }
                        paginationHtml += `</ul></nav>`;
                        $('#claimsPagination').html(paginationHtml);
                    },
                    error() {
                        $('#claimsDrilldownModalBody').html(
                            `<div class="alert alert-danger">Error loading claims.</div>`
                        );
                    }
                });
            }


            // Handle pagination click inside modal
            $(document).on('click', '#claimsPagination .page-link', function (e) {
                e.preventDefault();
                const page = $(this).data('page');
                const label = $('#claimsModalLabel').text();
                const statusMap = {
                    'Pending': 'pending',
                    'Under Review': 'under_review',
                    'Approved': 'approved',
                    'Rejected': 'rejected',
                    'Paid': 'paid',
                    'Closed': 'closed'
                };
                const status = statusMap[label] || null;
                if (status) loadClaimsByStatus(status, label, page);
            });


            // On page ready
            $(function () {
                loadClaims();

                // Period filter
                $('.status-filter').click(e => {
                    e.preventDefault();
                    const period = $(e.currentTarget).data('period');
                    loadClaims(period);
                });

                // Custom date range
                let selectedStart = null;
                let selectedEnd = null;

                const picker = new Litepicker({
                    element: document.getElementById('dateRangePicker'),
                    singleMode: false,
                    format: 'YYYY-MM-DD',
                    numberOfMonths: 2,
                    numberOfColumns: 2,
                    dropdowns: {
                        minYear: 2022,
                        maxYear: new Date().getFullYear(),
                        months: true,
                        years: true
                    },
                    setup: (picker) => {
                        picker.on('selected', (start, end) => {
                            selectedStart = start.format('YYYY-MM-DD');
                            selectedEnd = end.format('YYYY-MM-DD');
                        });
                    }
                });

                $('#applyDateRange').click(() => {
                    if (selectedStart && selectedEnd) {
                        $('#selectedRange').text(`${selectedStart} → ${selectedEnd}`);
                        loadClaims('custom', selectedStart, selectedEnd);
                        $('.dropdown-menu.show').removeClass('show'); // Close dropdown manually
                    } else {
                        toastr.warning("Please select both dates.");
                    }
                });

            });
        })();
    </script>




    <script>
        let currentStatus = 'all';
        let customerChart = null;

        function capitalize(str) {
            return str.charAt(0).toUpperCase() + str.slice(1);
        }

        function animateCounter($el, endValue, duration = 800) {
            const startValue = parseInt($el.text().replace(/,/g, '')) || 0;
            const range = endValue - startValue;
            const startTime = performance.now();

            function update(currentTime) {
                const elapsed = currentTime - startTime;
                const progress = Math.min(elapsed / duration, 1);
                const value = Math.floor(startValue + range * progress);
                $el.text(new Intl.NumberFormat().format(value));
                if (progress < 1) requestAnimationFrame(update);
            }

            requestAnimationFrame(update);
        }


        function loadCustomerChart(status = 'all') {
            currentStatus = status;
            $('#customer-loader').removeClass('d-none'); // ✅ Show loader
            $('#total-customers-chart').empty(); // Optional: clear previous chart

            $.ajax({
                url: '<?php echo e(route("admin.dashboard.customer-summary")); ?>',
                method: 'GET',
                data: { status: status },
                dataType: 'json',
                success: function (response) {
                    if (!response || typeof response.total === 'undefined') {
                        toastr.error("Invalid data returned");
                        $('#customer-loader').addClass('d-none'); // ✅ Hide loader
                        return;
                    }

                    // Update UI

                    animateCounter($('#customer-total'), response.total);


                    $('#status-label').text(response.status ? capitalize(response.status) : 'All');

                    const chartData = response.chart.map(item => item.total);
                    const chartLabels = response.chart.map(item => item.month);

                    const options = {
                        chart: {
                            type: 'area',
                            height: 100,
                            sparkline: { enabled: true },
                            events: {
                                click: function () {
                                    $('#customerDrilldownModal').modal('show');
                                }
                            }
                        },
                        series: [{ data: chartData }],
                        stroke: { curve: 'smooth', width: 2 },
                        tooltip: { enabled: true },
                        colors: ['#0d6efd']
                    };

                    if (customerChart) {
                        customerChart.updateSeries([{ data: chartData }]);
                        $('#customer-loader').addClass('d-none'); // ✅ Hide after update
                    } else {
                        customerChart = new ApexCharts(document.querySelector("#total-customers-chart"), options);
                        customerChart.render().then(() => {
                            $('#customer-loader').addClass('d-none'); // ✅ Hide after render completes
                        });
                    }

                    toastr.success("Customer data loaded");
                },
                error: function (xhr, status, error) {
                    console.error("AJAX error:", error);
                    toastr.error("Failed to load customer chart");
                    $('#customer-loader').addClass('d-none'); // ✅ Hide loader on error
                }
            });
        }

        $(document).ready(function () {
            // Initial load
            loadCustomerChart();

            // Filter by customer status
            $(document).on('click', '.customer-status-filter', function (e) {
                e.preventDefault();
                const status = $(this).data('status');
                loadCustomerChart(status);
            });

            // Export customers
            $('#export-customers').on('click', function () {
                window.location.href = `<?php echo e(route('admin.dashboard.export-customers')); ?>?status=${currentStatus}`;
            });
        });
    </script>

    <script>
        let policyStatus = 'all';
        let policyChart = null;
        let currentPolicyPage = 1;
        let searchKeyword = '';

        function animateCounterpolicy($el, endValue, duration = 800) {
            const startValue = parseInt($el.text().replace(/,/g, '')) || 0;
            const range = endValue - startValue;
            const startTime = performance.now();

            function update(currentTime) {
                const elapsed = currentTime - startTime;
                const progress = Math.min(elapsed / duration, 1);
                const value = Math.floor(startValue + range * progress);
                $el.text(new Intl.NumberFormat().format(value));
                if (progress < 1) requestAnimationFrame(update);
            }

            requestAnimationFrame(update);
        }


        function loadPolicyChart(status = 'all') {
            policyStatus = status;

            const $loader = $('#policy-loader');
            const $chart = $('#active-policies-chart');

            // Show loader by removing d-none
            $loader.removeClass('d-none');

            $.ajax({
                url: '<?php echo e(route("admin.policy-summary")); ?>',
                method: 'GET',
                data: { status },
                dataType: 'json',
                success: function (response) {
                    if (!response || typeof response.total === 'undefined') {
                        toastr.error("Invalid data");
                        $loader.addClass('d-none');
                        return;
                    }

                    // Update text
                    animateCounterpolicy($('#policy-total'), response.total);
                    $('#policy-status-label').text(
                        status === 'all' ? 'All' : status.charAt(0).toUpperCase() + status.slice(1)
                    );

                    const chartData = response.chart.map(item => item.total);

                    const options = {
                        series: [{ data: chartData }],
                        chart: {
                            type: 'area',
                            height: 90,
                            offsetY: -10,
                            toolbar: { show: false },
                            events: {
                                click: function () {
                                    openPolicyDrilldown(policyStatus); // ✅ Call drilldown here
                                }
                            }
                        },


                        stroke: { width: 2, curve: 'smooth' },
                        fill: {
                            type: 'gradient',
                            gradient: {
                                shadeIntensity: 1,
                                opacityFrom: 0.5,
                                opacityTo: 0.1,
                                stops: [0, 80, 100],
                            },
                        },
                        grid: {
                            show: false,
                            padding: { top: 5, bottom: -30 }
                        },
                        dataLabels: { enabled: false },
                        colors: ['#6f42c1'],
                        xaxis: {
                            labels: { show: false },
                            axisBorder: { show: false },
                            axisTicks: { show: false }
                        },
                        yaxis: { labels: { show: false } },
                        tooltip: { enabled: true },
                    };

                    if (policyChart) {
                        policyChart.destroy();
                    }

                    policyChart = new ApexCharts($chart[0], options);
                    policyChart.render().then(() => {
                        // ✅ Hide loader after render completes
                        $loader.addClass('d-none');
                    });

                    toastr.success("Policy data loaded");
                },
                error: function () {
                    $loader.addClass('d-none');
                    toastr.error("Failed to load policy chart");
                }
            });
        }

        $(function () {
            setTimeout(() => {
                loadPolicyChart();
            }, 300);

            // Filter event
            $(document).on('click', '.policy-status-filter', function (e) {
                e.preventDefault();
                const status = $(this).data('status');
                loadPolicyChart(status);
            });

            $('#export-policies').on('click', function () {
                window.location.href = `<?php echo e(route('admin.export-policies')); ?>?status=${policyStatus}`;
            });
        });

        function getStatusBadgeClass(status) {
            switch (status) {
                case 'active': return 'bg-success text-white';
                case 'inactive': return 'bg-secondary text-white';
                case 'cancelled': return 'bg-danger text-white';
                case 'expired': return 'bg-warning text-dark';
                case 'pending': return 'bg-info text-dark';
                default: return 'bg-light text-dark';
            }
        }

        function capitalize(str) {
            return str.charAt(0).toUpperCase() + str.slice(1);
        }

        function loadPolicyDrilldown(status = 'all', page = 1, search = '') {
            $('#policyDrilldownStatus').text(status.charAt(0).toUpperCase() + status.slice(1));
            $('#policy-drilldown-loader').removeClass('d-none');
            $('#policyDrilldownTableContainer, #policyDrilldownPagination').addClass('d-none');

            $.ajax({
                url: '<?php echo e(route("admin.dashboard.policy-drilldown")); ?>',
                method: 'GET',
                data: { status, page, search },
                success: function (response) {
                    let html = '';
                    const { data, current_page, last_page } = response;

                    if (!data || data.length === 0) {
                        html = `<tr><td colspan="7" class="text-center text-muted">No policies found.</td></tr>`;
                    } else {
                        data.forEach((policy, index) => {
                            html += `
                                            <tr class="policy-row" data-id="${policy.id}" style="cursor:pointer">
                                                <td>${(current_page - 1) * 10 + index + 1}</td>
                                                <td>${policy.policy_number}</td>
                                                <td>${policy.policy_name}</td>
                                                <td><span class="badge ${getStatusBadgeClass(policy.status)}">${capitalize(policy.status)}</span></td>
                                                <td>${policy.start_date}</td>
                                                <td>${policy.end_date}</td>
                                                <td>${parseFloat(policy.premium_amount).toLocaleString()} ETB</td>
                                            </tr>`;
                        });
                    }

                    $('#policyDrilldownTableBody').html(html);
                    $('#policy-drilldown-loader').addClass('d-none');
                    $('#policyDrilldownTableContainer').removeClass('d-none');

                    // Pagination
                    if (last_page > 1) {
                        let paginationHTML = '';
                        for (let i = 1; i <= last_page; i++) {
                            paginationHTML += `<li class="page-item ${i === current_page ? 'active' : ''}">
                                            <a class="page-link policy-page-link" href="#" data-page="${i}">${i}</a>
                                        </li>`;
                        }
                        $('#policyPaginationList').html(paginationHTML);
                        $('#policyDrilldownPagination').removeClass('d-none');
                    } else {
                        $('#policyDrilldownPagination').addClass('d-none');
                    }
                },
                error: function () {
                    toastr.error('Failed to load policies.');
                    $('#policy-drilldown-loader').addClass('d-none');
                }
            });
        }

        function openPolicyDrilldown(status = 'all') {
            policyStatus = status;
            currentPolicyPage = 1;
            searchKeyword = '';
            $('#policySearchInput').val('');
            $('#policyDrilldownModal').modal('show');
            loadPolicyDrilldown(policyStatus, currentPolicyPage, searchKeyword);
        }

        $(document).ready(function () {
            // Initial chart load
            loadPolicyChart();

            // Status filter click
            $(document).on('click', '.policy-status-filter', function (e) {
                e.preventDefault();
                loadPolicyChart($(this).data('status'));
            });

            // Export button
            $('#export-policies').on('click', function () {
                window.location.href = `<?php echo e(route('admin.export-policies')); ?>?status=${policyStatus}`;
            });

            // Pagination click
            $(document).on('click', '.policy-page-link', function (e) {
                e.preventDefault();
                currentPolicyPage = $(this).data('page');
                loadPolicyDrilldown(policyStatus, currentPolicyPage, searchKeyword);
            });

            // Search input
            $('#policySearchInput').on('input', function () {
                searchKeyword = $(this).val();
                loadPolicyDrilldown(policyStatus, 1, searchKeyword);
            });


            // Loader for Policies #


            function openPolicyModal(id) {
                const loader = $('#policy-modal-loader');
                loader.removeClass('d-none');
                $('#policyDetailModal').modal('show');

                $('#customer').html('');
                $('#policy').html('');
                $('#claims').html('');

                // Load customer
                $.get(`/admin/admin/api/policy/${id}/customer`, function (data) {
                    $('#customer').html(`
                      <ul class="list-group">
                        <li class="list-group-item"><strong>Name:</strong> ${data.name}</li>
                        <li class="list-group-item"><strong>Gender:</strong> ${data.gender}</li>
                        <li class="list-group-item"><strong>Email:</strong> ${data.email}</li>
                        <li class="list-group-item"><strong>Phone:</strong> ${data.phone}</li>
                        <li class="list-group-item"><strong>DOB:</strong> ${data.dob}</li>
                      </ul>
                    `);
                }).fail(() => {
                    $('#customer').html('<div class="text-danger">❌ Failed to load customer data.</div>');
                });

                // Load policy
                $.get(`/admin/admin/api/policy/${id}/policy`, function (data) {
                    $('#policy').html(`
                      <ul class="list-group">
                        <li class="list-group-item"><strong>Policy #:</strong> ${data.policy_number}</li>
                        <li class="list-group-item"><strong>Name:</strong> ${data.policy_name}</li>
                        <li class="list-group-item"><strong>Status:</strong> <span class="badge bg-info">${data.status}</span></li>
                        <li class="list-group-item"><strong>Sum Assured:</strong> ${parseFloat(data.sum_assured).toLocaleString()} ETB</li>
                        <li class="list-group-item"><strong>Premium:</strong> ${parseFloat(data.premium_amount).toLocaleString()} ETB</li>
                      </ul>
                    `);
                }).fail(() => {
                    $('#policy').html('<div class="text-danger">❌ Failed to load policy data.</div>');
                });

                // Load claims
                $.get(`/admin/admin/api/policy/${id}/claims`, function (data) {
                    if (!data.length) {
                        $('#claims').html('<div class="text-muted">No claims found.</div>');
                        loader.addClass('d-none');
                        return;
                    }

                    const rows = data.map(claim => `
                      <tr>
                        <td>#${claim.id}</td>
                        <td>${claim.claim_type}</td>
                        <td><span class="badge bg-${claim.claim_status === 'approved' ? 'success' : claim.claim_status === 'rejected' ? 'danger' : 'warning'}">${claim.claim_status}</span></td>
                        <td>${parseFloat(claim.claim_amount_requested).toLocaleString()} ETB</td>
                      </tr>
                    `).join('');

                    $('#claims').html(`
                      <div class="table-responsive">
                        <table class="table table-hover table-sm table-inverse table-striped table-bordered">
                          <thead class="table-light">
                            <tr><th>ID</th><th>Type</th><th>Status</th><th>Amount</th></tr>
                          </thead>
                          <tbody>${rows}</tbody>
                        </table>
                      </div>
                    `);
                    loader.addClass('d-none');
                }).fail(() => {
                    $('#claims').html('<div class="text-danger">❌ Failed to load claims.</div>');
                    loader.addClass('d-none');
                });

                // Hide loader when all done (safety fallback)
                setTimeout(() => loader.addClass('d-none'), 1500);
            }



            // Trigger
            $(document).on('click', '.policy-row', function () {
                const id = $(this).data('id');
                openPolicyModal(id);
            });


        });
    </script>




    <script>
        let premiumChart = null;
        let currentPremiumRange = 'all';
        let customFrom = null;
        let customTo = null;

        function animateCounter($el, endValue, duration = 1000) {
            const startValue = parseInt($el.text().replace(/[^\d]/g, '')) || 0;
            const range = endValue - startValue;
            const startTime = performance.now();

            function update(currentTime) {
                const elapsed = currentTime - startTime;
                const progress = Math.min(elapsed / duration, 1);
                const value = Math.floor(startValue + range * progress);
                $el.text(`Birr ${new Intl.NumberFormat().format(value)}`);
                if (progress < 1) requestAnimationFrame(update);
            }

            requestAnimationFrame(update);
        }

        function loadPremiumChart(range = 'all', from = null, to = null) {
            const $loader = $('#premium-loader');
            const $chart = $('#premium-chart');
            currentPremiumRange = range;
            customFrom = from;
            customTo = to;

            $loader.removeClass('d-none');
            $chart.empty();

            const requestData = { range };
            if (range === 'custom') {
                requestData.from = from;
                requestData.to = to;
            }

            $.ajax({
                url: '<?php echo e(route("admin.premium-summary")); ?>',
                method: 'GET',
                data: requestData,
                success: function (response) {
                    animateCounter($('#premium-total'), response.total);
                    $('#premium-filter-label').text(range === 'custom' ? 'Custom' : range.charAt(0).toUpperCase() + range.slice(1));
                    $('#premium-range-label').text(response.label || '');

                    const options = {
                        series: [{ name: '', data: response.chart }],
                        chart: { type: 'area', height: 90, offsetY: -10, toolbar: { show: false } },
                        stroke: { width: 2, curve: 'smooth' },
                        fill: {
                            type: 'gradient',
                            gradient: { shadeIntensity: 1, opacityFrom: 0.5, opacityTo: 0.1, stops: [0, 80, 100] }
                        },
                        grid: { show: false, padding: { top: 5, bottom: -30 } },
                        dataLabels: { enabled: false },
                        colors: ['#28a745'],
                        xaxis: { labels: { show: false }, axisBorder: { show: false }, axisTicks: { show: false } },
                        yaxis: { labels: { show: false } },
                        tooltip: { enabled: true },
                    };

                    if (premiumChart) premiumChart.destroy();
                    premiumChart = new ApexCharts($chart[0], options);
                    premiumChart.render().then(() => $loader.addClass('d-none'));
                },
                error: function () {
                    $loader.addClass('d-none');
                    toastr.error("Failed to load premium chart");
                }
            });
        }

        $(function () {
            loadPremiumChart();

            // Regular filter click
            $(document).on('click', '.premium-filter', function (e) {
                e.preventDefault();
                const range = $(this).data('range');
                if (range !== 'custom') loadPremiumChart(range);
            });

            // Flatpickr inline range
            flatpickr("#customDateInline", {
                mode: "range",
                dateFormat: "Y-m-d",
                onClose: function (selectedDates) {
                    if (selectedDates.length === 2) {
                        const from = selectedDates[0].toISOString().split('T')[0];
                        const to = selectedDates[1].toISOString().split('T')[0];
                        loadPremiumChart('custom', from, to);
                        $('.dropdown-menu').removeClass('show'); // Optional: auto-close dropdown
                    }
                }
            });
        });


    </script>

    <script>
        let invoiceRange = 'all';
        let invoiceChart = null;
        let invoiceFrom = '';
        let invoiceTo = '';

        function formatBirr(amount) {
            return 'Birr ' + parseFloat(amount).toLocaleString();
        }

        function loadInvoiceData() {
            $('#invoice-loader').removeClass('d-none');
            $('#invoice-error').addClass('d-none').text('');

            $.ajax({
                url: '<?php echo e(route("admin.invoice-summary")); ?>',
                method: 'GET',
                data: {
                    range: invoiceRange,
                    from: invoiceFrom,
                    to: invoiceTo
                },
                success: function (response) {
                    $('#invoice-total').html(`<small class="text-muted fs-6">Birr</small> ${parseFloat(response.total_amount).toLocaleString()}`);
                    $('#invoice-subtext').text(`${response.total_invoices} Pending Collections`);

                    const chartData = response.chart.map(item => item.total);
                    const chartLabels = response.chart.map(item => item.label);

                    const options = {
                        series: [{ name: 'Amount', data: chartData }],
                        chart: {
                            type: 'area',
                            height: 90,
                            offsetY: -10,
                            toolbar: { show: false }
                        },
                        stroke: { width: 2, curve: 'smooth' },
                        fill: {
                            type: "gradient",
                            gradient: {
                                shadeIntensity: 1,
                                opacityFrom: 0.5,
                                opacityTo: 0.1,
                                stops: [0, 80, 100]
                            }
                        },
                        grid: {
                            show: false,
                            padding: { top: 5, bottom: -30 }
                        },
                        dataLabels: { enabled: false },
                        colors: ['#dc3545'],
                        xaxis: {
                            categories: chartLabels,
                            labels: { show: false },
                            axisBorder: { show: false },
                            axisTicks: { show: false }
                        },
                        yaxis: {
                            labels: { show: false },
                        },
                        tooltip: {
                            y: {
                                formatter: (val) => formatBirr(val)
                            }
                        }
                    };

                    if (invoiceChart) invoiceChart.destroy();
                    invoiceChart = new ApexCharts(document.querySelector("#invoice-chart"), options);
                    invoiceChart.render();

                    $('#invoice-loader').addClass('d-none');
                },
                error: function () {
                    $('#invoice-error').removeClass('d-none').text('❌ Failed to load invoice data.');
                    $('#invoice-loader').addClass('d-none');
                }
            });
        }

        $(document).ready(function () {
            loadInvoiceData(); // Load default (all)

            // Handle dropdown filters
            $(document).on('click', '.invoice-filter', function (e) {
                e.preventDefault();
                invoiceRange = $(this).data('range');
                invoiceFrom = '';
                invoiceTo = '';
                $('#invoice-filter-label').text($(this).text());
                $('#invoiceCustomRange').addClass('d-none');
                loadInvoiceData();
            });

            // Handle custom range apply
            $('#invoiceApplyCustomRange').on('click', function () {
                invoiceRange = 'custom';
                invoiceFrom = $('#invoiceFromDate').val();
                invoiceTo = $('#invoiceToDate').val();

                if (!invoiceFrom || !invoiceTo) {
                    $('#invoice-error').removeClass('d-none').text('❗ Please select both dates.');
                    return;
                }

                $('#invoice-filter-label').text('Custom');
                loadInvoiceData();
            });

            // Show custom range picker
            flatpickr("#invoiceCustomDateRange", {
                mode: "range",
                dateFormat: "Y-m-d",
                onClose: function (selectedDates) {
                    if (selectedDates.length === 2) {
                        // Dates selected (start and end)
                        const from = selectedDates[0].toISOString().split('T')[0];
                        const to = selectedDates[1].toISOString().split('T')[0];

                        // Update your filter variables, then call load function
                        invoiceRange = 'custom';
                        invoiceFromDate = from;
                        invoiceToDate = to;

                        $('#invoice-filter-label').text(`Custom: ${from} to ${to}`);

                        loadInvoiceData(invoiceRange, invoiceFromDate, invoiceToDate);
                    }
                }
            });

            $('.invoice-filter').on('click', function (e) {
                e.preventDefault();

                invoiceRange = $(this).data('range');
                invoiceFromDate = null;
                invoiceToDate = null;

                $('#invoice-filter-label').text($(this).text());

                loadInvoiceData(invoiceRange);
            });

        });
    </script>


    <script>
        $(document).ready(function () {
            const loader = $('#chart-dash-2-line-loader');
            const toast = (msg, type = 'success') => toastr[type](msg);

            let currentRange = 'yearly';
            let customDates = null;

            // Initialize flatpickr
            flatpickr("#salesCustomDate", {
                mode: "range",
                dateFormat: "Y-m-d",
                onClose: function (selectedDates) {
                    if (selectedDates.length === 2) {
                        customDates = {
                            from: selectedDates[0].toISOString().split('T')[0],
                            to: selectedDates[1].toISOString().split('T')[0]
                        };
                        currentRange = 'custom';
                        fetchSalesStats();
                    }
                }
            });

            // Handle dropdown filter clicks
            $(document).on('click', '.sales-stat-filter', function (e) {
                e.preventDefault();
                currentRange = $(this).data('range');
                customDates = null;
                fetchSalesStats();
            });

            function formatBirr(amount) {
                return 'Birr ' + Number(amount).toLocaleString();
            }

            function calcPercentChange(current, previous) {
                if (!previous || previous === 0) return '+0%';
                const percent = ((current - previous) / previous) * 100;
                return (percent > 0 ? '+' : '') + percent.toFixed(1) + '%';
            }


            function setChangeArrow(value, percentId, upId, downId) {
                const percent = parseFloat(value).toFixed(2) + '%';
                $(`#${percentId}`).text(percent);

                if (parseFloat(value) > 0) {
                    $(`#${upId}`).removeClass('d-none');
                    $(`#${downId}`).addClass('d-none');
                } else if (parseFloat(value) < 0) {
                    $(`#${downId}`).removeClass('d-none');
                    $(`#${upId}`).addClass('d-none');
                } else {
                    $(`#${upId}, #${downId}`).addClass('d-none');
                }
            }

            // Declare chart globally
            let chartInstance = null;

            function fetchSalesStats() {
                loader.removeClass('d-none');
                const data = { range: currentRange };

                if (currentRange === 'custom' && customDates) {
                    data.from = customDates.from;
                    data.to = customDates.to;
                }

                $.ajax({
                    url: "<?php echo e(route('admin.dashboard.stats')); ?>",
                    method: 'GET',
                    data: data,
                    success: function (res) {

                        // Update label text
                        let label = '';
                        switch (currentRange) {
                            case 'daily': label = 'Daily'; break;
                            case 'weekly': label = 'Weekly'; break;
                            case 'monthly': label = 'Monthly'; break;
                            case 'yearly': label = 'Yearly'; break;
                            case 'custom':
                                label = customDates ? `Custom (${customDates.from} → ${customDates.to})` : 'Custom';
                                break;
                            default: label = 'Yearly';
                        }
                        $('#sales-stat-label').text(`(${label})`);

                        // Update statistics
                        $('#total-premium').text('Birr ' + Number(res.total_premium).toLocaleString());
                        $('#total-leads').text(res.total_leads);
                        $('#policies-sold').text(res.total_policies_sold);


                        // Apply percent change logic
                        setChangeArrow(res.premium_change, 'premium-percent', 'premium-up', 'premium-down');
                        setChangeArrow(res.leads_change, 'leads-percent', 'leads-up', 'leads-down');
                        setChangeArrow(res.policy_change, 'policies-percent', 'policies-up', 'policies-down');

                        // Percent Changes
                        $('#premium-percent')
                            .text((res.premium_change >= 0 ? '+' : '') + res.premium_change + '%')
                            .removeClass('font-success font-danger')
                            .addClass(res.premium_change >= 0 ? 'font-success' : 'font-danger');

                        $('#leads-percent')
                            .text((res.leads_change >= 0 ? '+' : '') + res.leads_change + '%')
                            .removeClass('font-success font-danger')
                            .addClass(res.leads_change >= 0 ? 'font-success' : 'font-danger');

                        $('#policies-percent')
                            .text((res.policies_change >= 0 ? '+' : '') + res.policies_change + '%')
                            .removeClass('font-success font-danger')
                            .addClass(res.policies_change >= 0 ? 'font-success' : 'font-danger');

                        // Clear existing chart instance if present
                        if (chartInstance !== null) {
                            chartInstance.destroy();
                        }

                        // Initialize new chart instance
                        chartInstance = new ApexCharts(document.querySelector("#chart-dash-2-line"), {
                            series: res.chart_series,
                            chart: {
                                height: 270,
                                type: 'line',
                                toolbar: { show: false },
                                dropShadow: {
                                    enabled: true,
                                    top: 4,
                                    left: 1,
                                    blur: 8,
                                    color: ['#5A87FF', '#8D8D8D'],
                                    opacity: 0.6,
                                },
                            },
                            stroke: { curve: 'smooth', width: [3, 3], dashArray: [0, 4] },
                            fill: { type: 'solid', opacity: [0.2, 1] },
                            grid: {
                                show: true,
                                borderColor: 'rgba(106, 113, 133, 0.30)',
                                strokeDashArray: 3,
                            },
                            labels: res.labels,
                            xaxis: {
                                categories: res.labels,
                                labels: {
                                    style: {
                                        fontFamily: 'Outfit, sans-serif',
                                        fontWeight: 500,
                                        colors: '#8D8D8D',
                                    },
                                },
                                axisBorder: { show: false },
                            },
                            yaxis: {
                                labels: {
                                    formatter: value => value.toLocaleString(),
                                    style: {
                                        fontFamily: 'Outfit, sans-serif',
                                        fontWeight: 500,
                                        colors: '#3D434A',
                                    },
                                },
                            },
                            markers: {
                                size: [3, 0],
                                colors: ['#3D434A'],
                                strokeWidth: [0, 0],
                            },
                            tooltip: {
                                shared: true,
                                intersect: false,
                                y: {
                                    formatter: y => typeof y !== "undefined" ? y.toFixed(0) : y,
                                },
                            },
                            colors: ['#5A87FF', '#8D8D8D'],
                            legend: { show: false },
                        });

                        chartInstance.render();
                        loader.addClass('d-none');
                    },
                    error: function () {
                        toast('Failed to load sales statistics', 'error');
                        loader.addClass('d-none');
                    }
                });
            }
            // Initial fetch
            fetchSalesStats();
        });
    </script>


<script>
document.addEventListener("DOMContentLoaded", function () {
  const mainCalendarEl = document.getElementById("calendar");
  const modalCalendarEl = document.getElementById("calendarModal");
  const modalLoader = document.getElementById("modal-calendar-loader");
  const cardLoader = document.getElementById("calendar-card-loader");
  const appointmentModal = document.getElementById("openAppointmentModal");

  const eventModalEl = document.getElementById("eventDetailsModal");
  const eventModalBody = eventModalEl.querySelector(".modal-body");
  const eventModal = new bootstrap.Modal(eventModalEl);

  let modalCalendar = null;

  const toast = (msg, type = 'error') => toastr[type](msg);

  // === MAIN CALENDAR ===
  const mainCalendar = new FullCalendar.Calendar(mainCalendarEl, {
    initialView: "dayGridMonth",
    height: 500,
    nowIndicator: true,
    editable: false,
    selectable: false,
    eventDisplay: 'block',
    dayMaxEventRows: true,
    eventMaxStack: 3,
    headerToolbar: {
      left: "prev,next today",
      center: "title",
      right: "dayGridMonth,timeGridWeek,timeGridDay,listMonth"
    },
    events: (info, success, fail) => fetchEvents(info, success, fail, cardLoader),
    eventContent: renderCustomEvent,
    eventClick: showEventDetails
  });

  mainCalendar.render();
  setTimeout(() => mainCalendar.updateSize(), 50);
  window.addEventListener('load', () => mainCalendar.updateSize());

  // === MODAL CALENDAR ===
  appointmentModal.addEventListener("shown.bs.modal", function () {
    if (modalCalendar) {
      modalCalendar.destroy();
      modalCalendar = null;
      modalCalendarEl.innerHTML = "";
    }

    modalCalendar = new FullCalendar.Calendar(modalCalendarEl, {
      initialView: "timeGridWeek",
      height: "100%",
      nowIndicator: true,
      editable: false,
      selectable: false,
      eventDisplay: 'block',
      headerToolbar: {
        left: "prev,next today",
        center: "title",
        right: "dayGridMonth,timeGridWeek,timeGridDay,listMonth"
      },
      events: (info, success, fail) => fetchEvents(info, success, fail, modalLoader),
      eventContent: renderCustomEvent,
      eventClick: showEventDetails
    });

    modalCalendar.render();
  });

  appointmentModal.addEventListener("hidden.bs.modal", function () {
    if (modalCalendar) {
      modalCalendar.destroy();
      modalCalendar = null;
    }
    modalCalendarEl.innerHTML = "";
    modalLoader?.classList.add("d-none");
  });

  // === RANGE DROPDOWN ===
  document.querySelectorAll(".calendar-range").forEach(btn => {
    btn.addEventListener("click", function (e) {
      e.preventDefault();
      const range = this.dataset.range;
      const today = new Date();
      switch (range) {
        case "daily": mainCalendar.changeView("timeGridDay", today); break;
        case "weekly": mainCalendar.changeView("timeGridWeek", today); break;
        case "monthly": mainCalendar.changeView("dayGridMonth", today); break;
        case "yearly": mainCalendar.changeView("dayGridMonth", today); break;
      }
    });
  });

  // === FETCH EVENTS ===
  function fetchEvents(info, successCallback, failureCallback, loader = null) {
    if (loader) loader.classList.remove("d-none");

    fetch(`api/appointments?start=${info.startStr}&end=${info.endStr}`)
      .then(res => {
        if (!res.ok) throw new Error("Network error");
        return res.json();
      })
      .then(successCallback)
      .catch(error => {
        toast("Failed to load calendar events");
        console.error(error);
        failureCallback(error);
      })
      .finally(() => {
        if (loader) loader.classList.add("d-none");
      });
  }

  // === RENDER CUSTOM EVENT ===
  function renderCustomEvent(info) {
    const event = info.event;
    const viewType = info.view.type;
    const title = event.title || "Untitled";

    const bgClass = event.classNames.includes("bg-light-info") ? "bg-gradient-info" :
                    event.classNames.includes("bg-light-success") ? "bg-gradient-success" :
                    event.classNames.includes("bg-light-danger") ? "bg-gradient-danger" :
                    event.classNames.includes("bg-light-warning") ? "bg-gradient-warning" :
                    "bg-gradient-primary";

    if (viewType === "dayGridMonth") {
      return { html: `<div class="fc-event-title ${bgClass} text-white p-1 rounded">${title}</div>` };
    } else {
      return {
        html: `
        <div class="fc-task-box ${bgClass} text-white p-1 rounded small">
          <div class="fc-task-text-box">
            <span class="fc-task-text">${title}</span>
          </div>
        </div>
        `
      };
    }
  }

  // === SHOW EVENT DETAILS MODAL ===
  function showEventDetails(info) {
    eventModalBody.innerHTML = `
      <div class="d-flex justify-content-center align-items-center" style="height:150px;">
        <div class="spinner-border text-primary" role="status">
          <span class="visually-hidden">Loading...</span>
        </div>
      </div>`;
    eventModal.show();

    fetch(`appointments/${info.event.id}`)
      .then(res => {
        if (!res.ok) throw new Error("Failed to fetch event details");
        return res.json();
      })
      .then(data => {
        const start = new Date(data.start).toLocaleString();
        const end = new Date(data.end).toLocaleString();

        const html = `
          <div class="event-details">
            <h5 class="mb-3 text-primary fw-bold">${data.title}</h5>
            <ul class="list-group list-group-flush">
              <li class="list-group-item bg-transparent d-flex justify-content-between">
                <strong>Customer</strong><span>${data.customer_name}</span>
              </li>
              <li class="list-group-item bg-transparent d-flex justify-content-between">
                <strong>Start</strong><span>${start}</span>
              </li>
              <li class="list-group-item bg-transparent d-flex justify-content-between">
                <strong>End</strong><span>${end}</span>
              </li>
              <li class="list-group-item bg-transparent d-flex justify-content-between">
                <strong>Status</strong><span class="badge ${data.status === 'completed' ? 'bg-success' : data.status === 'cancelled' ? 'bg-danger' : 'bg-info'}">${data.status}</span>
              </li>
              ${data.location ? `<li class="list-group-item bg-transparent d-flex justify-content-between">
                <strong>Location</strong><span>${data.location}</span>
              </li>` : ''}
              <li class="list-group-item bg-transparent">
                <strong>Description</strong>
                <div class="mt-1">${data.description || '<em>No description provided.</em>'}</div>
              </li>
            </ul>
          </div>`;

        eventModalBody.innerHTML = html;
      })
      .catch(err => {
        console.error(err);
        eventModalBody.innerHTML = `<p class="text-danger">Could not load event details.</p>`;
      });
  }
});
</script>



<script>
$(document).ready(function () {
  const $mapContainer = $('#ethiopia-map');
  const $legendContainer = $('#map-legend');

  // Define lat/lng for Ethiopian states
  const stateCoordsLatLng = {
    'Addis Ababa': [9.03, 38.7469],
    'Amhara': [11.59, 37.75],
    'Oromia': [8.98, 39.5],
    'Sidama': [6.75, 38.25],
    'SNNPR': [6.5, 37.75],
    'Somali': [6.0, 44.0],
    'Tigray': [14.0, 39.5]
  };

  // Show loader overlay
  function showLoader() {
    if ($('#map-loader').length === 0) {
      $mapContainer.append(`
        <div id="map-loader" style="
          position: absolute;
          top: 0; left: 0; right: 0; bottom: 0;
          background: rgba(255,255,255,0.7);
          display: flex;
          align-items: center;
          justify-content: center;
          font-size: 1.5rem;
          z-index: 9999;
        ">Loading map data...</div>
      `);
    }
  }

  // Hide loader overlay
  function hideLoader() {
    $('#map-loader').remove();
  }

  showLoader();

  $.ajax({
    url: '/state-customer-counts', // Your API endpoint returning {stateName: count}
    method: 'GET',
    success: function (stateData) {
      hideLoader();

      // Initialize the map without markers first
      $mapContainer.vectorMap({
  map: 'africa_mill',
  backgroundColor: 'transparent',
  regionStyle: {
    initial: { fill: '#e0e0e0' }
  },
  focusOn: {
    lat: 9.145,     // Ethiopia center approx
    lng: 40.4897,
    scale: 5        // Adjust zoom level
  },
  zoomOnScroll: false,
  markers: [],
  markerStyle: {
    initial: {
        fill: "#007bff",
      stroke: '#ffffff',
      r: 8
    },
    hover: {
      fill: '#FF5722'
    }
  },
  onMarkerTipShow: function (event, label, index) {
    label.html(markers[index].name);
  }
});


      const mapObject = $mapContainer.vectorMap('get', 'mapObject');

      const markers = [];

      Object.entries(stateData).forEach(([state, count]) => {
        if (!stateCoordsLatLng[state]) {
          console.warn(`Coordinates missing for state: ${state}`);
          return;
        }
        const latLng = stateCoordsLatLng[state]; // [lat, lng]
        const point = mapObject.latLngToPoint(latLng);

        markers.push({
          name: `${state}: ${count} customers`,
          x: point.x,
          y: point.y
        });
      });

      // Add markers dynamically after map initialized
      mapObject.addMarkers(markers);

      // Save markers globally for tooltip access
      window.markers = markers;

      // Render legend
      renderLegend(stateData);
    },
    error: function () {
      hideLoader();
      alert('Failed to load state customer data.');
    }
  });

  // Render a simple legend in #map-legend container
  function renderLegend(stateData) {
    if (!$legendContainer.length) return;

    let html = '<h5>Customers by Region</h5><ul style="list-style:none; padding-left:0;">';

    Object.entries(stateData).forEach(([state, count]) => {
      html += `
        <li style="margin-bottom:8px; display:flex; align-items:center;">
          <span style="
            display:inline-block;
            width:16px;
            height:16px;
            background:#00AB4E;
            margin-right:8px;
            border-radius:3px;
          "></span>
          <strong>${state}:</strong> ${count}
        </li>
      `;
    });

    html += '</ul>';

    $legendContainer.html(html);
  }
});

</script>











<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/oriontje/crm.oriontechet.com/resources/views/admin/dashboard/index.blade.php ENDPATH**/ ?>