<?php $__env->startSection('title', 'Customer List'); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/animate.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/animate.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/owlcarousel.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/rating.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/js-datatables/style.css')); ?>">
    <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    
    <style>
.hover-underline:hover {
    text-decoration: underline !important;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="<?php echo e(route('admin.dashboard')); ?>"><img class="img-fluid for-light"
                    src="<?php echo e(asset('assets/images/logo/logo.png')); ?>" alt="" /><img class="img-fluid for-dark"
                    src="<?php echo e(asset('assets/images/logo/logo_light.png')); ?>" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Customer list</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Customer</li>
                <li class="breadcrumb-item f-w-400 active">Customer list</li>
            </ol>
        </nav>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="list-product-header">
                            <div>
                                <div class="light-box"><a data-bs-toggle="collapse" href="#collapseProduct" role="button"
                                        aria-expanded="false" aria-controls="collapseProduct"><i class="filter-icon show"
                                            data-feather="filter"></i><i class="icon-close filter-close hide"></i></a></div>
                                <a class="btn btn-primary" href="<?php echo e(route('admin.customers.create')); ?>"><i class="fa fa-plus"></i>Add
                                    Customer</a>
                            </div>
<div class="collapse" id="collapseCustomer">
    <div class="card card-body list-customer-body">
        <div class="row row-cols-xl-5 row-cols-lg-4 row-cols-md-3 row-cols-sm-2 row-cols-2 g-3">
            <!-- Name Search -->
            <div class="col">
                <input type="text" class="form-control" placeholder="Search by name" id="customer-name-search">
            </div>
            
            <!-- Contact Filter -->
            <div class="col">
                <input type="text" class="form-control" placeholder="Phone or email" id="customer-contact-filter">
            </div>
            
            <!-- Location Filter -->
            <div class="col">
                <select class="form-select" id="customer-location-filter">
                    <option selected value="">All Locations</option>
                    <option value="city">By City</option>
                    <option value="country">By Country</option>
                    <option value="region">By Region</option>
                </select>
            </div>
            
            <!-- Status Filter -->
            <div class="col">
                <select class="form-select" id="customer-status-filter">
                    <option selected value="">All Statuses</option>
                    <option value="active">Active</option>
                    <option value="inactive">Inactive</option>
                    <option value="blacklisted">Blacklisted</option>
                </select>
            </div>
            
            <!-- Registration Date -->
            <div class="col">
                <select class="form-select" id="customer-date-filter">
                    <option selected value="">Registration Date</option>
                    <option value="today">Today</option>
                    <option value="week">This Week</option>
                    <option value="month">This Month</option>
                    <option value="year">This Year</option>
                    <option value="custom">Custom Range</option>
                </select>
            </div>
            
            <!-- Additional Row for Custom Filters -->
            <div class="col-12 mt-3 additional-filters" style="display: none;">
                <div class="row g-3">
                    <!-- ID Type Filter -->
                    <div class="col-md-4">
                        <select class="form-select" id="customer-id-type-filter">
                            <option selected value="">ID Type</option>
                            <option value="national_id">National ID</option>
                            <option value="passport">Passport</option>
                            <option value="tax_id">Tax ID</option>
                        </select>
                    </div>
                    
                    <!-- Income Range -->
                    <div class="col-md-4">
                        <select class="form-select" id="customer-income-filter">
                            <option selected value="">Income Range</option>
                            <option value="low">Low (0-50k)</option>
                            <option value="medium">Medium (50k-200k)</option>
                            <option value="high">High (200k+)</option>
                        </select>
                    </div>
                    
                    <!-- Employment Status -->
                    <div class="col-md-4">
                        <select class="form-select" id="customer-employment-filter">
                            <option selected value="">Employment Status</option>
                            <option value="employed">Employed</option>
                            <option value="unemployed">Unemployed</option>
                            <option value="self-employed">Self-Employed</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <!-- Filter Buttons -->
            <div class="col-12 mt-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <button class="btn btn-primary me-2" id="apply-filters">
                            <i class="fas fa-filter me-1"></i> Apply Filters
                        </button>
                        <button class="btn btn-outline-secondary" id="reset-filters">
                            <i class="fas fa-sync-alt me-1"></i> Reset
                        </button>
                    </div>
                    <button class="btn btn-link" id="toggle-advanced-filters">
                        <i class="fas fa-sliders-h me-1"></i> Advanced Filters
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>                        </div>
                        <div class="list-cusotmer">
                <table class="table table-striped" id="customer-list">
                    <thead>
                        <tr>
                            <th>
                                <div class="form-check">
                                    <input class="form-check-input checkbox-primary" type="checkbox" id="select-all">
                                </div>
                            </th>
                            <th>Customer ID</th>
                            <th>Photo</th>
                            <th>Full Name</th>
                            <th>Contact</th>
                            <th>ID Number</th>
                            <th>Location</th>
                            <th>Status</th>
                            <th>Registered</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <!-- calendar js-->
        <script src="<?php echo e(asset('assets/js/rating/jquery.barrating.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/rating/rating-script.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/owlcarousel/owl.carousel.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/js-datatables/simple-datatables@latest.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/custom-list-product.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/ecommerce.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/tooltip-init.js')); ?>"></script>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
                <script>
        $(document).ready(function() {
            let table = $('#customer-list').DataTable({
                processing: true,
                serverSide: true,
                ajax: "<?php echo e(route('customers.data')); ?>", // Laravel route
                columns: [
                    { data: 'checkbox', name: 'checkbox', orderable: false, searchable: false },
                    { data: 'id', name: 'id' },
                    { data: 'photo', name: 'photo', orderable: false, searchable: false },
                    { data: 'full_name', name: 'full_name' },
                    { data: 'contact', name: 'contact' },
                    { data: 'id_number', name: 'id_number' },
                    { data: 'location', name: 'location' },
                    { data: 'status', name: 'status' },
                    { data: 'registered', name: 'registered' },
                    { data: 'actions', name: 'actions', orderable: false, searchable: false },
                ],
                order: [[1, 'desc']],
                responsive: true
            });
        
            // Handle "Select All" checkbox
            $('#select-all').on('click', function () {
                var rows = table.rows({ 'search': 'applied' }).nodes();
                $('input[type="checkbox"]', rows).prop('checked', this.checked);
            });
        });
        </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/oriontje/crm.oriontechet.com/resources/views/admin/customers/index.blade.php ENDPATH**/ ?>