<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClaimsTable extends Migration
{
    public function up()
    {
        Schema::create('claims', function (Blueprint $table) {
            $table->id();

            // Foreign Keys for Customer Types
            $table->foreignId('customer_id')->nullable()->constrained('customers')->onDelete('cascade');
            $table->foreignId('corporate_customer_id')->nullable()->constrained('corporate_customers')->onDelete('cascade');

            // Policy Info
            $table->foreignId('policy_id')->constrained('policies')->onDelete('cascade');
            $table->string('policy_number');

            // Claim Details
            $table->string('claim_number')->unique();
            $table->enum('claim_type', ['accident', 'theft', 'fire', 'natural_disaster', 'medical', 'other']);
            $table->date('incident_date');
            $table->string('incident_location');
            $table->text('incident_description');

            // Claim Financials
            $table->decimal('claim_amount_requested', 20, 2);
            $table->decimal('claim_amount_approved', 20, 2)->nullable();
            $table->decimal('deductible', 20, 2)->default(0.00);
            $table->decimal('settlement_amount', 20, 2)->nullable();

            // Status Tracking
            $table->enum('claim_status', ['pending', 'under_review', 'approved', 'rejected', 'paid', 'closed'])->default('pending');
            $table->timestamp('submitted_at')->nullable();
            $table->timestamp('reviewed_at')->nullable();
            $table->timestamp('approved_at')->nullable();
            $table->timestamp('settled_at')->nullable();

            // Supporting Info
            $table->text('supporting_documents')->nullable(); // Can be a JSON or file paths
            $table->text('adjuster_notes')->nullable();
            $table->string('assigned_adjuster')->nullable();

            // Internal System Tracking
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('updated_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('claims');
    }
}
