<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('audit_logs', function (Blueprint $table) {
            $table->id();

            // Who performed the action
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();

            // Affected target (e.g. customer, corporate_customer, policy, etc.)
            $table->string('auditable_type'); // e.g., App\Models\Customer
            $table->unsignedBigInteger('auditable_id');

            // What was done
            $table->string('action'); // e.g., created, updated, deleted, logged_in, downloaded_document
            $table->json('old_values')->nullable();
            $table->json('new_values')->nullable();

            // Metadata
            $table->ipAddress('ip_address')->nullable();
            $table->string('user_agent')->nullable();
            $table->string('platform')->nullable(); // e.g., web, mobile, api
            $table->string('location')->nullable(); // optional: IP-based location or manual input

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('audit_logs');
    }
};
