<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('password_reset_tokens', function (Blueprint $table) {
            // Columns
            $table->string('email', 255); // No primary key defined (matches SQL)
            $table->string('token', 255);
            $table->timestamp('created_at')->nullable();

            // If you want to follow Laravel conventions, add:
            // $table->primary('email');
        });

        // Explicit database configuration
        Schema::table('password_reset_tokens', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('password_reset_tokens');
    }
};