<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('claim_logs', function (Blueprint $table) {
            // Primary Key
            $table->increments('id'); // int(11) NOT NULL
            
            // Foreign Key
            $table->unsignedBigInteger('claim_id'); // bigint(20) UNSIGNED
            $table->foreign('claim_id')
                  ->references('id')
                  ->on('claims')
                  ->onDelete('cascade');

            // Status Tracking
            $table->enum('status', [
                'submitted',
                'under review',
                'approved',
                'rejected',
                'paid'
            ]);

            // Notes
            $table->text('note')->nullable();

            // Timestamp
            $table->timestamp('created_at')->useCurrent();
        });

        // Explicit database configuration
        Schema::table('claim_logs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('claim_logs');
    }
};