<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('claim_status_history', function (Blueprint $table) {
            // Primary Key
            $table->bigIncrements('id'); // bigint(20) UNSIGNED NOT NULL

            // Foreign Key
            $table->foreignId('claim_id') // bigint(20) UNSIGNED NOT NULL
                  ->constrained()
                  ->onDelete('cascade');

            // Status Columns
            $table->enum('previous_status', [
                    'pending',
                    'approved',
                    'rejected',
                    'in_review'
                ])
                ->nullable();

            $table->enum('new_status', [
                    'pending',
                    'approved',
                    'rejected',
                    'in_review'
                ])
                ->nullable();

            // Timestamp
            $table->timestamp('changed_at')->useCurrent();
        });

        // Explicit database configuration
        Schema::table('claim_status_history', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('claim_status_history');
    }
};