<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        Schema::create('api_logs', function (Blueprint $table) {
            // Primary Key
            $table->increments('id'); // int(11) NOT NULL

            // API Request Details
            $table->string('endpoint', 255);
            $table->enum('request_method', ['GET', 'POST', 'PUT', 'DELETE']);
            
            // Payloads with JSON validation
            $table->longText('request_payload')->nullable();
            $table->longText('response_payload')->nullable();
            
            // Status Code
            $table->integer('status_code');

            // Timestamp
            $table->timestamp('created_at')->useCurrent();
        });

        // Add JSON validation constraints
        DB::statement('ALTER TABLE api_logs 
            ADD CONSTRAINT api_logs_request_payload_check 
            CHECK (json_valid(request_payload))');

        DB::statement('ALTER TABLE api_logs 
            ADD CONSTRAINT api_logs_response_payload_check 
            CHECK (json_valid(response_payload))');

        // Explicit database configuration
        Schema::table('api_logs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('api_logs');
    }
};