<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('user_activity_logs', function (Blueprint $table) {
            // Primary Key (int(11) NOT NULL)
            $table->increments('id'); // Creates INT UNSIGNED AUTO_INCREMENT
            
            // Foreign Key
            $table->foreignId('user_id') // BIGINT(20) UNSIGNED
                ->constrained()
                ->onDelete('cascade');

            // Activity Details
            $table->string('action', 255);
            $table->text('description')->nullable();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();

            // Timestamp
            $table->timestamp('created_at')->useCurrent();
        });

        // Explicit database configuration
        Schema::table('user_activity_logs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('user_activity_logs');
    }
};