<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('claim_attachments', function (Blueprint $table) {
            // Primary Key
            $table->bigIncrements('id'); // bigint(20) UNSIGNED NOT NULL
            
            // Foreign Key
            $table->foreignId('claim_id') // bigint(20) UNSIGNED NOT NULL
                  ->constrained()
                  ->onDelete('cascade');

            // File Details
            $table->string('file_path', 255)->nullable(); // varchar(255) DEFAULT NULL
            $table->string('file_type', 50)->nullable(); // varchar(50) DEFAULT NULL
            
            // Timestamp
            $table->timestamp('uploaded_at')->useCurrent(); // DEFAULT CURRENT_TIMESTAMP
        });

        // Explicit database configuration
        Schema::table('claim_attachments', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('claim_attachments');
    }
};