<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        Schema::create('system_logs', function (Blueprint $table) {
            // Primary Key (int(11) NOT NULL)
            $table->increments('id'); // Creates INT UNSIGNED AUTO_INCREMENT
            
            // Event Classification
            $table->enum('event_type', [
                'error',
                'info',
                'warning'
            ]);

            // Log Details
            $table->text('message');
            $table->longText('details')->nullable();

            // Timestamp
            $table->timestamp('created_at')->useCurrent();
        });

        // Add JSON validation constraint
        DB::statement('ALTER TABLE system_logs 
            ADD CONSTRAINT system_logs_details_check 
            CHECK (json_valid(details))');

        // Explicit database configuration
        Schema::table('system_logs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('system_logs');
    }
};