<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('customer_documents', function (Blueprint $table) {
            // Primary Key (int(11) NOT NULL)
            $table->increments('id'); // Auto-incrementing INTEGER
            
            // Foreign Key
            $table->foreignId('user_id') // BIGINT(20) UNSIGNED
                ->constrained()
                ->onDelete('cascade');

            // Document Details
            $table->enum('document_type', [
                'ID Proof',
                'Address Proof',
                'Medical Report'
            ]);

            $table->string('file_path', 255);

            // Timestamp
            $table->timestamp('uploaded_at')->useCurrent();
        });

        // Explicit database configuration
        Schema::table('customer_documents', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('customer_documents');
    }
};