<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class CitiesTableSeeder extends Seeder
{
    public function run()
    {
        $now = Carbon::now();

        $cities = [
            // Southern Nations, Nationalities, and Peoples' Region (SNNPR)
            ['name' => 'Konta', 'region_id' => 11],
            ['name' => 'Bench Sheko', 'region_id' => 11],
            ['name' => 'Dawuro', 'region_id' => 11],
            ['name' => 'Kafa ', 'region_id' => 11],  // Note: Trailing space preserved
            ['name' => 'West Omo ', 'region_id' => 11],  // Note: Trailing space preserved
            ['name' => 'Sheka', 'region_id' => 11],
        ];

        // Add timestamps
        $cities = array_map(function($item) use ($now) {
            return $item + ['created_at' => $now, 'updated_at' => $now];
        }, $cities);

        DB::table('cities')->insert($cities);
    }
}