<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class LeadSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        $maleNames = ['Abebe', 'Kebede', 'Getachew', 'Birhanu', 'Yohannes'];
        $femaleNames = ['Tigist', 'Selam', 'Rahel', 'Hiwot', 'Mekdes'];
        $lastNames = ['Gebre', 'Hailu', 'Asfaw', 'Tadesse', 'Demissie'];
        $industries = ['Banking', 'Education', 'Construction', 'Transport', 'Technology'];
        $sources = ['website', 'walk-in', 'phone call', 'referral'];
        $statuses = ['new', 'contacted', 'qualified', 'converted', 'lost'];
        $priorities = ['low', 'medium', 'high'];
        $companyNames = ['EthioTech', 'Habesha Logistics', 'Bunna Bank', 'Addis Engineering', 'Walia Construction'];

        for ($i = 0; $i < 500; $i++) {
            $leadType = $faker->randomElement(['individual', 'corporate']);
            $gender = $faker->randomElement(['male', 'female']);

            $firstName = $gender === 'male' ? $faker->randomElement($maleNames) : $faker->randomElement($femaleNames);
            $middleName = $faker->randomElement(array_merge($maleNames, $femaleNames));
            $lastName = $faker->randomElement($lastNames);

            $email = $faker->unique()->safeEmail;
            $phone = '+2519' . $faker->numerify('########');

            $companyName = $leadType === 'corporate' ? $faker->randomElement($companyNames) : null;
            $contactPerson = $leadType === 'corporate' ? $faker->randomElement(array_merge($maleNames, $femaleNames)) . ' ' . $faker->randomElement($lastNames) : null;
            $contactPhone = $leadType === 'corporate' ? '+2519' . $faker->numerify('########') : null;
            $contactEmail = $leadType === 'corporate' ? $faker->unique()->companyEmail : null;
            $industry = $leadType === 'corporate' ? $faker->randomElement($industries) : null;

            $status = $faker->randomElement($statuses);
            $priority = $faker->randomElement($priorities);
            $source = $faker->randomElement($sources);

            $lastContacted = rand(0, 1) ? $faker->dateTimeBetween('2025-01-01', 'now') : null;
            $nextFollowUp = rand(0, 1) ? $faker->dateTimeBetween('now', '+2 months') : null;

            $createdAt = $faker->dateTimeBetween('2025-01-01', 'now');
            $updatedAt = $faker->dateTimeBetween($createdAt, 'now');

            DB::table('leads')->insert([
                'lead_type' => $leadType,
                'first_name' => $firstName,
                'middle_name' => $middleName,
                'last_name' => $lastName,
                'email' => $email,
                'phone' => $phone,
                'company_name' => $companyName,
                'contact_person' => $contactPerson,
                'contact_phone' => $contactPhone,
                'contact_email' => $contactEmail,
                'industry' => $industry,
                'notes' => $faker->sentence(8), // short English summary
                'source' => $source,
                'status' => $status,
                'priority' => $priority,
                'last_contacted_at' => $lastContacted,
                'next_follow_up_at' => $nextFollowUp,
                'assigned_to' => 1,
                'customer_id' => null,
                'corporate_customer_id' => null,
                'created_at' => $createdAt,
                'updated_at' => $updatedAt,
                'deleted_at' => null,
            ]);
        }
    }
}
