<h6 class="fw-bold mb-3">Associated Claims</h6>

@if ($claims->isEmpty())
    <div class="text-muted text-center py-3">No claims found for this policy.</div>
@else
    <table class="table table-sm table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>Claim Number</th>
                <th>Status</th>
                <th>Filed Date</th>
                <th>Amount</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($claims as $index => $claim)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $claim->claim_number }}</td>
                    <td>
                        <span class="badge
                            @if($claim->status == 'approved') bg-success
                            @elseif($claim->status == 'pending') bg-warning
                            @elseif($claim->status == 'rejected') bg-danger
                            @else bg-secondary @endif">
                            {{ ucfirst($claim->status) }}
                        </span>
                    </td>
                    <td>{{ \Carbon\Carbon::parse($claim->filed_at)->toFormattedDateString() }}</td>
                    <td>{{ number_format($claim->amount, 2) }} ETB</td>
                    <td>
                        <a href="{{ route('admin.claims.show', $claim->id) }}" class="btn btn-sm btn-outline-primary">View</a>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endif
