@extends('layouts.master')

@section('title', 'MDE-Editor')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/simple-mde.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">MDE Editor</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Editors</li>
                <li class="breadcrumb-item f-w-400 active">MDE Editor</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <h4>First Example</h4>
                    </div>
                    <div class="card-body">
                        <div id="editor_container">
                            <textarea id="editable">A site designer is now very important in the digital age since the internet provides access to information, entertainment, and business. A web designer is an important architect of virtual user experiences in addition to being a maker of visually appealing websites. This essay explores many different aspects of a web designer's job, including their creative process, technical expertise, and contribution to the world of computers and smartphones. Web design is fundamentally the art and science of creating visually magnificent useful, and user-friendly websites. Creating an online presence that successfully conveys a client's brand identity, message, and offerings is the main goal of a web designer. In order to meet the goals of the customer and improve the user experience, components of design must strike an appropriate equilibrium between imaginative thinking and a pragmatic perspective. Moreover, throughout the design and development phase, web designers are frequently collaborating closely with developers, content producers, and other stakeholders. Taking into account deadlines for projects and budgetary constraints while becoming aware the client's vision necessitates effective communication and teamwork.  The layout, appearance, and style of web pages are managed using this language. To maintain uniformity and coherence throughout the website, a web designer's CSS knowledge is essential. Every component of the website may be altered, from spacing to picture and button placement.
A qualified expert who is in charge of developing and designing websites is known as a web designer. They make advantage of their knowledge of current web design trends to create websites that are both aesthetically pleasing and user-friendly. Making sure that the websites they develop are responsive—that is, that they easily adjust to multiple screen sizes and devices—is a crucial component of their work. This guarantees that users, regardless of the device they are using, can access and navigate the website efficiently. A web designer is technically proficient as well as having a good sense of aesthetics and color. They take care to choose color palettes that go with the corporate identity and deliver the intended message. The website's efficacy and overall user experience can be significantly impacted by the color scheme. A web designer can develop a visually appealing website that grabs visitors' attention.
Web designers use CSS as a crucial tool to realize their creative ambitions. The layout, appearance, and style of web pages are managed using this language. To maintain uniformity and coherence throughout the website, a web designer's CSS knowledge is essential. Every component of the website may be altered with CSS, from typefaces and spacing to picture and button placement. By leveraging CSS, a web designer is able to create a visually stunning website that aligns with the client's objectives and enhances the user's interaction with the site. A web designer not only concentrates on producing websites that are aesthetically pleasing but also pays great attention to the appropriate use of color. They are aware of the psychology underlying color and how it might influence people' feelings and behaviors. A web designer may create a unified and aesthetically pleasant experience for visitors by carefully selecting color schemes that complement the brand and message of the website. A practitioner with expertise in building attractive and useful websites is known as a web designer. Their primary objective is to create responsive websites, which can adjust to and show properly on various platforms including PCs, tablets, and mobile phones. A web designer gives considerable thought to a website's style, navigation, and general user experience to make sure the target audience will find it easy to use and visually appealing.
Knowledge of user psychology, design concepts, and usability testing techniques are essential for UX designers. Additionally, they must possess strong communication skills with both technical and user stakeholders.training and education The educational road to become a UX designer is not one-size-fits-all. The majority of UX designers, however, have degrees in design, computer science, or human-computer interaction. Additionally, there are several UX design courses that are offered both online and in person.Career prospects: Job prospects for UX designers are excellent. UX designers' employment is expected to increase by 13% between 2020 and 2030, according to the Bureau of Labour Statistics, which is substantially faster than the average for all occupations.Making a product or service functional, pleasurable, and accessible is the responsibility of the UX designer. Although many businesses create user experiences, the phrase is frequently connected to digital design for websites and mobile applications. The broad design phases tend to remain the same, even though the actual process changes from product to product and firm to company.
The professional who is in charge with designing a website's visual elements is known as a web designer. Their primary priorities are with a website's aesthetics and user experience (UX), in order to ensure that it conveys the intended message or corporate identity in an effective, pleasing to the eye and comprehensible way. Web designers produce layouts, color schemes, typography, and other visual elements of a website using a variety of graphic design tools and software. They frequently work along with stakeholders or clients to comprehend their brand requirements and style preferences. UI design is the process used to create the forms, menus, navigation, buttons, and other interface elements that users interact with on a website. To improve the user experience overall, web designers pay attention on making all of these elements straightforward and easy to use. Web designers need to make sure their websites are responsive, which means they can easily adjust to various screen sizes and devices, given the growing popularity of mobile devices. This involves developing adaptable layouts and the user experience across desktop, tablet, and smartphone platforms by implementing methodologies like media queries. Web designers frequently draft prototypes to describe the functionality, and content hierarchy of a website before moving on to the graphic design stage. This aids in the layout modification process for them and clients prior to moving forward with the design work.</textarea>
                        </div>
                        <div id="html_container"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <h4>Second Example</h4>
                    </div>
                    <div class="card-body">
                        <div class="row editor_container">
                            <div class="col-md-6">
                                <textarea class="CodeMirror" id="smde"></textarea>
                            </div>
                            <div class="col-md-6 reader" id="write_here"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <!-- calendar js-->
    <script src="{{ asset('assets/js/editor/simple-mde/simplemde.min.js') }}"></script>
    <script src="{{ asset('assets/js/editor/simple-mde/simplemde.custom.js') }}"></script>
    <script src="{{ asset('assets/js/tooltip-init.js') }}"></script>
@endsection
