<?php

namespace Database\Factories;

use App\Models\Customer;
use Illuminate\Database\Eloquent\Factories\Factory;

class PolicyFactory extends Factory
{
    public function definition(): array
    {
        return [
            'customer_id' => Customer::factory(),
            'policy_number' => strtoupper($this->faker->unique()->bothify('POL###??')),
            'class_of_business' => $this->faker->randomElement(['Motor', 'Fire', 'Third Party']),
            'policy_type' => $this->faker->randomElement(['Individual', 'Corporate']),
            'expiry_date' => $this->faker->dateTimeBetween('+3 months', '+1 year'),
        ];
    }
}
