<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

use App\Models\Customer;
use App\Models\Policy;
use App\Models\Claim;

class WorkOrderFactory extends Factory
{
    public function definition(): array
    {
        $policy = Policy::inRandomOrder()->first() ?? Policy::factory()->create();
        $claim = Claim::where('policy_id', $policy->id)->inRandomOrder()->first() ?? Claim::factory()->create([
            'policy_id' => $policy->id,
            'customer_id' => $policy->customer_id,
        ]);

        return [
            'customer_id' => $policy->customer_id,
            'cob' => $policy->class_of_business,
            'policy_id' => $policy->id, // ✅ INTEGER ID
            'claim_id' => $claim->id,
            'order_date' => $this->faker->dateTimeBetween('-1 year', 'now'),
            'garage_name' => $this->faker->company . ' Garage',
        ];
    }
}

