<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('policies', function (Blueprint $table) {
            // Primary Key
            $table->bigIncrements('id'); // bigint(20) UNSIGNED NOT NULL

            // Foreign Keys
            $table->foreignId('user_id')->constrained();
            $table->foreignId('beneficiary_id')
                ->nullable()
                ->constrained('customers')
                ->onDelete('set null');

            // Policy Details
            $table->string('policy_number', 50)->unique();
            $table->enum('policy_type', [
                'health', 'auto', 'life', 'property', 'travel'
            ]);
            $table->decimal('premium_amount', 15, 2);
            $table->decimal('sum_insured', 15, 2);
            $table->date('start_date');
            $table->date('end_date');

            // Status Information
            $table->enum('renewal_status', ['active', 'pending', 'expired'])
                ->default('active');
            $table->longText('coverage_details');
            $table->enum('status', ['active', 'expired', 'cancelled', 'pending'])
                ->default('active');
            $table->enum('payment_frequency', ['monthly', 'quarterly', 'annually'])
                ->default('monthly');

            // Timestamps
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrent()->useCurrentOnUpdate();

            // Indexes
            $table->index(['user_id', 'beneficiary_id']);
        });

        // Explicit database configuration
        Schema::table('policies', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('policies');
    }
};