<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('transaction_logs', function (Blueprint $table) {
            // Primary Key (Manual definition to match SQL's int(11) NOT NULL)
            $table->integer('id')->unsigned()->autoIncrement()->primary();
            
            // Foreign Key
            $table->unsignedBigInteger('transaction_id'); // bigint(20) UNSIGNED
            $table->foreign('transaction_id')
                  ->references('id')
                  ->on('transactions')
                  ->onDelete('cascade');

            // Status Tracking
            $table->enum('status', [
                'initiated',
                'completed',
                'failed',
                'refunded'
            ]);

            // Message Details
            $table->text('message')->nullable();

            // Timestamp
            $table->timestamp('created_at')->useCurrent();
        });

        // Explicit database configuration
        Schema::table('transaction_logs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('transaction_logs');
    }
};