<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('notification_logs', function (Blueprint $table) {
            // Primary Key (int(11) NOT NULL)
            $table->increments('id'); // Auto-incrementing INTEGER
            
            // Foreign Key
            $table->foreignId('notification_id') // BIGINT(20) UNSIGNED
                ->constrained()
                ->onDelete('cascade');

            // Status Tracking
            $table->enum('status', [
                'sent',
                'failed',
                'delivered',
                'read'
            ]);

            // Message Details
            $table->text('message');

            // Timestamp
            $table->timestamp('created_at')->useCurrent();
        });

        // Explicit database configuration
        Schema::table('notification_logs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('notification_logs');
    }
};