<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Customer;
use App\Models\Policy;
use App\Models\Claim;
use App\Models\SurveyStatus;
use App\Models\WorkOrder;
use App\Models\ClaimPayment;
use App\Models\GarageDischarge;


class MasterSeeder extends Seeder
{
    public function run(): void
    {
        \DB::disableQueryLog(); // Improve performance
        \DB::statement('SET FOREIGN_KEY_CHECKS=0');

        Customer::truncate();
        Policy::truncate();
        Claim::truncate();
        SurveyStatus::truncate();
        WorkOrder::truncate();
        ClaimPayment::truncate();
        GarageDischarge::truncate();

        \DB::statement('SET FOREIGN_KEY_CHECKS=1');

        $this->command->info("⏳ Seeding 2,000 Ethiopian customers...");

        Customer::factory()
            ->count(500)
            ->create()
            ->each(function ($customer) {
                // Create 1–3 policies per customer
                $policies = Policy::factory(rand(1, 3))->create([
                    'customer_id' => $customer->id,
                ]);

                foreach ($policies as $policy) {
                    // Create 0–2 claims per policy
                    $claims = Claim::factory(rand(0, 2))->create([
                        'policy_id' => $policy->id,
                    ]);

                    foreach ($claims as $claim) {
                        SurveyStatus::factory()->create(['claim_id' => $claim->id]);
                        WorkOrder::factory()->create(['claim_id' => $claim->id]);
                        ClaimPayment::factory()->create(['claim_id' => $claim->id]);
                        GarageDischarge::factory()->create(['claim_id' => $claim->id]);
                    }
                }
            });

        $this->command->info("✅ Done seeding 2000 customers + related data.");
    }}
