@extends('layouts.master')

@section('title', 'Sweet-alert2')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/prism.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/sweetalert2.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Sweet Alert</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Bonus Ui</li>
                <li class="breadcrumb-item f-w-400 active">Sweet Alert</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Position Top Start</h4>
                        <p class="f-m-light mt-1">Use <code> "position: top-start"</code> in javascript, you set the alert's
                            position.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"> </i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-secondary sweet-16" type="button"
                            onclick="_gaq.push(['_trackEvent', 'sweet-16']);">Click it! </button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#sweet-p-ts"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="sweet-p-ts">&lt;button class="btn btn-secondary sweet-16" type="button" onclick="_gaq.push(['_trackEvent', 'sweet-16']);"&gt;Click it! &lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Position Top End</h4>
                        <p class="f-m-light mt-1">Use <code> "position: top-end"</code> in javascript, you set the alert's
                            position.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-success sweet-15" type="button"
                            onclick="_gaq.push(['_trackEvent', 'sweet-15']);">Click it! </button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#sweet-p-te"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="sweet-p-te">&lt;button class="btn btn-success sweet-15" type="button" onclick="_gaq.push(['_trackEvent', 'sweet-15']);"&gt;Click it! &lt;/button&gt; </code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Position Bottom Start</h4>
                        <p class="f-m-light mt-1">Use <code> "position: bottom-start"</code> in javascript, you set the
                            alert's position.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-warning sweet-17" type="button"
                            onclick="_gaq.push(['_trackEvent', 'sweet-17']);">Click it! </button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#sweet-p-bs"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="sweet-p-bs">&lt;button class="btn btn-warning sweet-17" type="button" onclick="_gaq.push(['_trackEvent', 'sweet-17']);"&gt;Click it! &lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Position Bottom End</h4>
                        <p class="f-m-light mt-1">Use <code> "position: bottom-end"</code> in javascript, you set the
                            alert's position.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-primary sweet-18" type="button"
                            onclick="_gaq.push(['_trackEvent', 'sweet-18']);">Click it! </button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#sweet-p-be"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="sweet-p-be">&lt;button class="btn btn-primary sweet-18" type="button" onclick="_gaq.push(['_trackEvent', 'sweet-18']);"&gt;Click it! &lt;/button&gt; </code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Basic Example</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-1 </code>class to create a basic alert display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-primary sweet-1" type="button"
                            onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-1']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#sweet-basic"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="sweet-basic">&lt;button class="btn btn-primary sweet-1" type="button" onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-1']);"&gt;Click it!&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Title with a Text Under</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-2 </code>class to create a title with text under alert
                            display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-secondary sweet-2" type="button"
                            onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-2']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#sweet-title"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="sweet-title">&lt;button class="btn btn-secondary sweet-2" type="button" onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-2']);"&gt;Click it!&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Dismiss Alert </h4>
                        <p class="f-m-light mt-1">Use <code>sweet-3 </code>class to create a dismiss alert display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-success sweet-3" type="button"
                            onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-3']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#dismiss-alert"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="dismiss-alert">&lt;button class="btn btn-success sweet-3" type="button" onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-3']);"&gt;Click it!&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Rich Html Alert</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-4 </code>class to create a rich html alert display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-warning sweet-4" type="button"
                            onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-4']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#rich-alert"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="rich-alert">&lt;button class="btn btn-warning sweet-4" type="button" onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-4']);"&gt;Click it!&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Confirmation Alert</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-5 </code>class to create a confirmation alert display.
                        </p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-warning sweet-5" type="button"
                            onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-5']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#confirmation-alert"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="confirmation-alert">&lt;button class="btn btn-warning sweet-5" type="button" onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-5']);"&gt;Click it!&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Animated Alert</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-6 </code>class to create a animated alert display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-primary sweet-6" type="button"
                            onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-6']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#animated-alert"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="animated-alert">&lt;button class="btn btn-primary sweet-6" type="button" onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-6']);"&gt;Click it!&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Confirmation with Triggers</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-7 </code>class to create a confirmation with triggers
                            alert display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-secondary sweet-7" type="button"
                            onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-7']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard"
                                data-clipboard-target="#confirmation-triggers" title="Copy"><i
                                    class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="confirmation-triggers">&lt;button class="btn btn-secondary sweet-7" type="button" onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-7']);"&gt;Click it!&lt;/button&gt; </code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Image-rich Message</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-8 </code>class to create a image rich message alert
                            display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-success sweet-8" type="button"
                            onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-8']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#image-rich"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="image-rich">&lt;button class="btn btn-success sweet-8" type="button" onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-8']);"&gt;Click it!&lt;/button&gt; </code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Auto Close Timer</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-9 </code>class to create a auto close timer alert
                            display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-danger sweet-9" type="button"
                            onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-9']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#auto-close-timer"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="auto-close-timer">&lt;button class="btn btn-danger sweet-9" type="button" onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-9']);"&gt;Click it!&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>AJAX Request Alert</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-10 </code>class to create a ajax request alert display.
                        </p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-warning sweet-10" type="button"
                            onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-10']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#ajax-alert"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="ajax-alert">&lt;button class="btn btn-warning sweet-10" type="button" onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-10']);"&gt;Click it!&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Confirmation with Approvals</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-11 </code>class to create a confirmation with approvals
                            alert display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-primary sweet-11" type="button"
                            onclick="_gaq.push(['_trackEvent', 'sweet-11']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#approvals-sweet"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="approvals-sweet">&lt;button class="btn btn-primary sweet-11" type="button" onclick="_gaq.push(['_trackEvent', 'sweet-11']);"&gt;Click it!&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Comprehensive RTL Support</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-12 </code>class to create a comprehensive RTL support
                            alert display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-secondary sweet-12" type="button"
                            onclick="_gaq.push(['_trackEvent', 'sweet-12']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#rtl-support"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="rtl-support">&lt;button class="btn btn-secondary sweet-12" type="button" onclick="_gaq.push(['_trackEvent', 'sweet-12']);"&gt;Click it!&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Password Generator Alert</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-13 </code>class to create a password generator alert
                            display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-primary sweet-13" type="button"
                            onclick="_gaq.push(['_trackEvent', 'sweet-13']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#password-alert"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="password-alert">&lt;button class="btn btn-primary sweet-13" type="button" onclick="_gaq.push(['_trackEvent', 'sweet-13']);"&gt;Click it!&lt;/button&gt; </code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Date Alert</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-14 </code>class to create a date alert display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-danger sweet-14" type="button"
                            onclick="_gaq.push(['_trackEvent', 'sweet-14']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#date-alert"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="date-alert">&lt;button class="btn btn-danger sweet-14" type="button" onclick="_gaq.push(['_trackEvent', 'sweet-14']);"&gt;Click it!&lt;/button&gt; </code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Custom Positioned Dialog</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-19 </code>class to create a custom positioned dialog
                            alert display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-warning sweet-19" type="button"
                            onclick="_gaq.push(['_trackEvent', 'sweet-19']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard"
                                data-clipboard-target="#custom-positioned-dialog" title="Copy"><i
                                    class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="custom-positioned-dialog">&lt;button class="btn btn-warning sweet-19" type="button" onclick="_gaq.push(['_trackEvent', 'sweet-19']);"&gt;Click it!&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-sm-6 col-12 box-col-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Registration Form</h4>
                        <p class="f-m-light mt-1">Use <code>sweet-20 </code>class to create a input form alert display.</p>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option">
                                <li><i class="icon-more-alt"></i></li>
                                <li><i class="view-html fa fa-code"></i></li>
                                <li><i class="icofont icofont-maximize full-card"></i></li>
                                <li><i class="icofont icofont-minus minimize-card"></i></li>
                                <li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <button class="btn btn-primary sweet-20" type="button"
                            onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-20']);">Click it!</button>
                        <div class="code-box-copy">
                            <button class="code-box-copy__btn btn-clipboard" data-clipboard-target="#registration-form"
                                title="Copy"><i class="icofont icofont-copy-alt"></i></button>
                            <pre class="theme-scrollbar"><code class="language-html" id="registration-form">&lt;button class="btn btn-primary sweet-20" type="button" onclick="_gaq.push(['_trackEvent', 'example', 'try', 'sweet-20']);"&gt;Click it!&lt;/button&gt;</code></pre>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <script src="{{ asset('assets/js/prism/prism.min.js') }}"></script>
    <script src="{{ asset('assets/js/clipboard/clipboard.min.js') }}"></script>
    <script src="{{ asset('assets/js/custom-card/custom-card.js') }}"></script>
    <!-- calendar js-->
    <script src="{{ asset('assets/js/sweet-alert/sweetalert.min.js') }}"></script>
    <script src="{{ asset('assets/js/sweet-alert/app.js') }}"></script>
    <script src="{{ asset('assets/js/height-equal.js') }}"></script>
@endsection
