<?php

// app/Http/Controllers/AppointmentController.php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Carbon\Carbon;


use Illuminate\Http\Request;
use App\Models\Appointment;

use App\Models\Customer;

class AppointmentController extends Controller
{
    public function calendarData(Request $request)
    {
        try {
            $start = Carbon::parse(substr($request->start, 0, 19))->startOfDay();
            $end = Carbon::parse(substr($request->end, 0, 19))->endOfDay();
        } catch (\Exception $e) {
            return response()->json(['error' => 'Invalid date format'], 400);
        }

        $appointments = Appointment::whereBetween('start_time', [$start, $end])->get();

        return response()->json(
            $appointments->map(function ($appt) {
                return [
                    'id' => $appt->id,
                    'title' => $appt->subject,
                    'start' => $appt->start_time,
                    'end' => $appt->end_time,
                    'classNames' => [
                        match ($appt->status) {
                            'scheduled' => 'bg-light-info',
                            'completed' => 'bg-light-success',
                            'cancelled' => 'bg-light-danger',
                            default => 'bg-light-secondary',
                        },
                        'text-dark',
                    ],
                ];
            })
        );
    }

    public function index(Request $request)
    {
        $start = $request->query('start'); // e.g. 2025-07-01
        $end = $request->query('end');     // e.g. 2025-07-31

        $appointments = Appointment::whereBetween('start', [$start, $end])
            ->get(['id', 'title', 'start', 'end', 'classNames', 'description']); // classNames optional for styling

        // Format for FullCalendar
        $events = $appointments->map(function ($item) {
            return [
                'id' => $item->id,
                'title' => $item->title,
                'start' => $item->start,
                'end' => $item->end,
                'classNames' => $item->classNames ?? [],
            ];
        });

        return response()->json($events);
    }

    // GET /api/appointments/{id}
    public function show($id)
    {
        $appointment = Appointment::with('customer')->find($id);

        if (!$appointment) {
            return response()->json(['message' => 'Appointment not found'], 404);
        }

        $customer = $appointment->customer;

        $fullName = $customer
            ? trim("{$customer->first_name} {$customer->middle_name} {$customer->last_name}")
            : 'N/A';

        return response()->json([
            'id' => $appointment->id,
            'title' => $appointment->subject,
            'start' => $appointment->start_time,
            'end' => $appointment->end_time,
            'description' => $appointment->description,
            'location' => $appointment->location,
            'status' => $appointment->status,
            'customer_name' => $fullName,
        ]);
    }


}
