<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Policy;
use App\Models\Customer;
use App\Models\Claim;

class PolicyAjaxController extends Controller
{
    public function loadCustomer($id)
    {
        $policy = Policy::find($id);
        if (!$policy) return response("Policy not found", 404);

        $customer = Customer::find($policy->customer_id);
        if (!$customer) return response("Customer not found", 404);

        return response()->json([
            'name' => "{$customer->first_name} {$customer->last_name}",
            'gender' => $customer->gender,
            'email' => $customer->email,
            'phone' => $customer->phone,
            'dob' => $customer->date_of_birth,
        ]);
    }

    public function loadPolicy($id)
    {
        $policy = Policy::find($id);
        if (!$policy) return response("Policy not found", 404);

        return response()->json($policy);
    }

    public function loadClaims($id)
    {
        $claims = Claim::where('policy_id', $id)->get();

        return response()->json($claims);
    }
}
