<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;







class NotificationEmail extends Mailable
{
    use Queueable, SerializesModels;

    public string $body;

    public function __construct(string $body)
    {
        $this->body = $body;
    }

    public function build()
    {
        return $this->subject('Notification from NISCO') // Customize subject
                    ->view('emails.notification')
                    ->with(['body' => $this->body]);
    }
}
